/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.definition;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Yasuo Nakanishi
 */
public class FormSpecification {

    private String _formName = "";

    private String _formJpName = "";

    private String _endAddress = "";

    private boolean _hasBlockCountPerPage = false;

    private int _blockCountPerPage = 0;

    private FormDataStruct _dataStruct = null;

    private List _loopNames = new ArrayList();

    private Map _loopRangeMap = new Hashtable();

    public FormSpecification(String formName) {
        _formName = formName;
    }

    public String getEndAddress() {
        return _endAddress;
    }

    public void setEndAddress(String endAddress) {
        _endAddress = endAddress;
    }

    public void addBlock(String name, String range) {
        _loopNames.add(name);
        _loopRangeMap.put(name, range);
    }

    public String getLoopRange(String name) {
        return (String) _loopRangeMap.get(name);
    }

    public Iterator getLoopNameIterator() {
        return _loopNames.iterator();
    }

    public boolean hasLoop() {
        return !_loopNames.isEmpty();
    }

    public boolean hasBlockCountPerPage() {
        return _hasBlockCountPerPage;
    }

    public int getBlockCountPerPage() {
        assert hasBlockCountPerPage();
        return _blockCountPerPage;
    }

    public void setBlockCountPerPage(int pageBlocks) {
        _hasBlockCountPerPage = true;
        _blockCountPerPage = pageBlocks;
    }

    public FormDataStruct getDataStruct() {
        return _dataStruct;
    }

    public void setDataStruct(FormDataStruct dataStruct) {
        _dataStruct = dataStruct;
    }

    public String getFormName() {
        return _formName;
    }

    public String getFormJpName() {
        return _formJpName;
    }

    public void setFormJpName(String formJpName) {
        _formJpName = formJpName;
    }
}
