/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.definition;

/**
 * @author Yasuo Nakanishi
 */
public class OutputType {

    public static final OutputType XLS = new OutputType("XLS");

    public static final OutputType XLS_PDF = new OutputType("XLS_PDF");

    private String _name = "";

    public OutputType(String name) {
        _name = name;
    }

    public String getName() {
        return _name;
    }

    public static OutputType parse(String name) {
        OutputType result = null;
        if (name.equals("XLS")) {
            result = XLS;
        } else if (name.equals("XLS,PDF")) {
            result = XLS_PDF;
        } else {
            String message = "sȏo͖n܂B:" + name;
            throw new RuntimeException("");
        }
        return result;
    }
}
