/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.expander;

import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class TypeFactory {

    private String _rootNameSpace = "";

    public TypeFactory(String rootNameSpace) {
        _rootNameSpace = rootNameSpace;
    }

    public Type getRuntimeType(Class type) {
        String name = type.getName();
        if (name.startsWith("blanco.report.runtime")) {
            name = name.replaceFirst("blanco.report.runtime", _rootNameSpace
                    + ".runtime");
        } else if (name.startsWith("blanco.report.definition")) {
            name = name.replaceFirst("blanco.report.definition", _rootNameSpace
                    + ".runtime");
        } else if (name.startsWith("blanco.api")) {
            name = name.replaceFirst("blanco.api", _rootNameSpace + ".api");
        } else {
            String message = "\ȂpbP[Wn܂BNX:";
            message += name;
            throw new RuntimeException(message);

        }
        Type result = new Type(name);
        return result;
    }
}
