/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.expander.processor;

import java.util.Iterator;

import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;
import blanco.report.definition.FormSpecification;

/**
 * @author Yasuo Nakanishi
 */
public class NewPageMethod extends MethodExpander {

    private FormSpecification _specification = null;

    public NewPageMethod(FormSpecification specification) {
        super(createName(specification.getFormName()));
        _specification = specification;
    }

    public static String createName(String name) {
        return "new" + getNameAdjuster().toTitleCase(name) + "Page";
    }

    public void setupSignature() {
    }

    public void implement() {
        Implementor implementor = new Implementor(getData());
        Call c = new Call("newPage");
        c.addArgument(new StringLiteral(_specification.getFormName()));
        if (_specification.hasBlockCountPerPage()) {
            String count = Integer.toString(_specification
                    .getBlockCountPerPage());
            c.addArgument(new Statement(int.class, count));
        }
        implementor.addStatement(c);

        c = new Call("collectPageParameters");
        c.addArgument(new StringLiteral(_specification.getEndAddress()));
        implementor.addStatement(c);

        Iterator iterator = _specification.getLoopNameIterator();
        String name = "";
        String range = "";
        String source = "";
        while (iterator.hasNext()) {
            name = (String) iterator.next();
            range = _specification.getLoopRange(name);

            c = new Call("collectLoopParameters");
            c.addArgument(new StringLiteral(name));
            c.addArgument(new StringLiteral(range));
            implementor.addStatement(c);
        }

        String doc = "";
        doc = "V" + _specification.getFormName() + " y[W쐬B";
        getJavaDoc().addLine(doc);
    }
}
