/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.expander.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.api.excel.CellType;
import blanco.core.datastruct.GetListIteratorMethod;
import blanco.core.datastruct.ReadAccessor;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Cast;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;
import blanco.report.definition.BlockItem;
import blanco.report.definition.FieldSpecification;
import blanco.report.definition.FormDataStruct;
import blanco.report.definition.FormSpecification;
import blanco.report.expander.TypeFactory;

/**
 * @author Yasuo Nakanishi
 */
public class SetPageDataMethod extends MethodExpander {
    private FormSpecification _specification = null;

    private List _arguments = new ArrayList();

    private Value _pageDataArgument = null;

    private TypeFactory _typeFactory = null;

    public SetPageDataMethod(FormSpecification specification,
            TypeFactory typeFactory) {
        super(createName(specification.getFormName()));
        _specification = specification;
        _typeFactory = typeFactory;
    }

    public static String createName(String name) {
        String title = getNameAdjuster().toTitleCase(name);
        return getNameAdjuster().getMethodName("set", title + "PageData");
    }

    public void setupSignature() {
        FormDataStruct dataStruct = _specification.getDataStruct();
        Type type = dataStruct.getClassType();
        _pageDataArgument = new Value(type, "pageData");
        addArgument(_pageDataArgument);

        String doc = "";
        doc = _specification.getFormName() + " y[W̃f[^ݒ";
        getJavaDoc().addLine(doc);

        doc = _specification.getFormName() + " y[W̃f[^B";
        getJavaDoc().addParameter(_pageDataArgument.getName(), doc);
    }

    public void implement() {
        FormDataStruct dataStruct = _specification.getDataStruct();

        Iterator iterator = dataStruct.getFieldIterator();
        Call c = null;
        Receiver r = null;

        Implementor implementor = new Implementor(getData());

        c = new Call("checkCurrentForm");
        c.addArgument(new StringLiteral(_specification.getFormName()));
        implementor.addStatement(c);

        FieldSpecification field = null;
        String name = "";

        Type cellType = _typeFactory.getRuntimeType(CellType.class);

        while (iterator.hasNext()) {
            field = (FieldSpecification) iterator.next();
            name = field.getValue().getName();

            c = new Call("setValue");
            c.addArgument(new StringLiteral(name));
            r = new Receiver(cellType, field.getCellType().getName());
            c.addArgument(r);

            r = new Receiver(_pageDataArgument, ReadAccessor.createName(name));
            c.addArgument(r);

            implementor.addStatement(c);
        }

        Value listIterator = new Value(Iterator.class, "listIterator");

        if (_specification.hasLoop()) {
            implementor.emptyLine();
            implementor.declareByDefault(listIterator);
        }

        iterator = dataStruct.getBlocksIterator();
        BlockItem listItem = null;
        String method = "";
        Iterator fieldIterator = null;
        Value item = null;
        Type itemType = null;
        while (iterator.hasNext()) {
            listItem = (BlockItem) iterator.next();
            method = GetListIteratorMethod.createName(listItem.getName());

            itemType = listItem.getClassType();
            item = new Value(itemType, getNameAdjuster().toValueName(
                    listItem.getName()));
            implementor.declareByDefault(item);

            r = new Receiver(_pageDataArgument, method);
            implementor.assign(listIterator, r);

            r = new Receiver(listIterator, "hasNext");
            implementor.openWhile(r);

            Cast cast = new Cast(itemType);
            cast.value(listIterator).call("next");
            implementor.assign(item, cast);

            c = new Call("newLine");
            c.addArgument(new StringLiteral(listItem.getName()));
            implementor.addStatement(c);

            fieldIterator = listItem.getFieldIterator();
            while (fieldIterator.hasNext()) {
                field = (FieldSpecification) fieldIterator.next();
                name = field.getValue().getName();

                c = new Call("setBlockValue");
                c.addArgument(new StringLiteral(listItem.getName()));
                c.addArgument(new StringLiteral(name));
                r = new Receiver(cellType, field.getCellType().getName());
                c.addArgument(r);

                r = new Receiver(item, ReadAccessor.createName(name));
                c.addArgument(r);

                implementor.addStatement(c);
            }
            implementor.closeWhile();
        }
    }
}
