/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.generator;

import blanco.ig.generator.GeneratorSetting;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoReportSetting extends GeneratorSetting {

    private String _formSetDirectory = "";

    private String _formSetSpecificatoinDirctory = "";

    private String _openOfficeExecuteFile = "";

    private boolean _hideOpenOffce = true;

    private String _unoHost = "localhost";

    private int _unoPort = 8100;

    public BlancoReportSetting() {
        setRootNameSpace("blanco.report");
    }

    public String getFormSetDirectory() {
        return _formSetDirectory;
    }

    public void setFormSetDirectory(String reportFormDirectory) {
        _formSetDirectory = reportFormDirectory;
    }

    public String getFormSetSpecificatoinDirctory() {
        return _formSetSpecificatoinDirctory;
    }

    public void setFormSetSpecificatoinDirctory(
            String reportSpecificatoinDirctory) {
        _formSetSpecificatoinDirctory = reportSpecificatoinDirctory;
    }

    public String getUnoHost() {
        return _unoHost;
    }

    public void setUnoHost(String unoHost) {
        _unoHost = unoHost;
    }

    public int getUnoPort() {
        return _unoPort;
    }

    public void setUnoPort(int unoPort) {
        _unoPort = unoPort;
    }

    public String getOpenOfficeExecuteFile() {
        return _openOfficeExecuteFile;
    }

    public void setOpenOfficeExecuteFile(String openOfficeExecuteFile) {
        _openOfficeExecuteFile = openOfficeExecuteFile;
    }

    public boolean isHideOpenOffce() {
        return _hideOpenOffce;
    }

    public void setHideOpenOffce(boolean hideOpenOffce) {
        _hideOpenOffce = hideOpenOffce;
    }
}
