/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.collector;

import java.io.InputStream;
import java.util.Properties;

/**
 * @author Yasuo Nakanishi
 */
public class PropertiesLoader {
    private String _fileName = "";

    private Properties _properties = new Properties();

    public PropertiesLoader(String fileName) {
        _fileName = fileName;
    }

    public boolean load() {
        boolean result = false;
        InputStream stream = null;
        try {
            stream = ClassLoader.getSystemResourceAsStream(_fileName);
            if (stream != null) {
                _properties.load(stream);
                result = true;
            }
        } catch (Exception e) {
            String message = "vpeBt@C̓ǂݍ݂Ɏs܂Bt@C:";
            message += _fileName;
            RuntimeException re = new RuntimeException(message, e);
            throw re;
        }
        return result;
    }
    
    public Properties getResult() {
        return _properties;
    }
}
