/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander;

import blanco.ig.tool.ConsolePrinter;

/**
 * @author Yasuo Nakanishi
 */
public class NameAdjuster {
    private static ConsolePrinter _pritner = ConsolePrinter.get(); 

	public String toFieldName(String name) {
		return "_" + toFirstLowerString(name);
	}

	public String toValueName(String name) {
		return toFirstLowerString(name);
	}
	
	public String toValueName(String name, String suffix) {
		return toFirstLowerString(name) + suffix;
	}
	
	private String toFirstLowerString(String name) {
	    String work = upperWordToLower(name);
	    work = joinSeparator(name);
		StringBuffer sb = new StringBuffer();
		sb.append(work.toLowerCase().charAt(0));
		sb.append(work.substring(1, work.length()));
		return sb.toString();
	}

	public String toClassName(String name) {
		return joinSeparator(name);
	}

	public String toShortClassName(Class targetClass) {
		String result;
		String name = targetClass.getName();
		if(targetClass.isPrimitive()) {
			result = name;
		} else {
			int index = name.lastIndexOf('.') + 1;
			result = name.substring(index, name.length());
		}
		return result;
	}
	
	private String joinSeparator(String name) {
	    String[] word = name.replaceAll("^[-_ ]+||[-_ $]+", "").split("[-_ ]+");
	    for(int i = 0; i < word.length; i++) {
	        word[i] = upperWordToLower(word[i]);
	        word[i] = toTitleCase(word[i]);
	    }
	    StringBuffer sb = new StringBuffer();
	    for(int i = 0; i < word.length; i++) {
	        sb.append(word[i]);
	    }
	    return sb.toString();
	}

    public String getMethodName(String verb, String name) {
        String result = joinSeparator(name);
//        result = toTitleCase(result);
        return verb.toLowerCase() + result;
    }
    
    private String upperWordToLower(String name){
        String result = name;
        if(name.equals(name.toUpperCase())) {
            result = name.toLowerCase();
        }
        return result;
    }
    
    public String toTitleCase(String name) {
		assert name.length() > 0;
        
        if(name == null || name.length() == 0) {
            _pritner.printWarning("sȈn܂BAssertionLɂĎsĂB");
            return "";
        }
        
        StringBuffer sb = new StringBuffer(upperWordToLower(name));

        String firstChar = name.substring(0, 1).toUpperCase();
        sb.deleteCharAt(0);
        sb.insert(0, firstChar);
        return sb.toString();
    }

	public Type adjust(Type type) {
		String nameSpace = type.getNameSpace().toLowerCase();
		String className = toClassName(type.getName());
		Type result = new Type(nameSpace, className);
		return result;
	}
}
