/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.method;

import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class Constructor extends MethodExpander {
	private static NameAdjuster _nameAdjuster = new NameAdjuster();

	public Constructor(Type type) {
		this(_nameAdjuster.toClassName(type.getName()));
	}

	public Constructor(String type) {
		super(_nameAdjuster.toClassName(type));
	}

    public void setupSignature() {
        getJavaDoc().addLine("RXgN^B");
        getJavaDoc().addLine(getName() + "NXB");
        
        // TODO:p[^ɑΉB
    }

    protected String makeSignature(){
		StringBuffer sb = new StringBuffer();
		sb.append("\t");
		sb.append(getScope().get());
		sb.append(" ");
		sb.append(getName());
		sb.append("(");
		for(int i = 0; i < getArgumentCount(); i++){
			if(i != 0){
				sb.append(",");
			}
			sb.append(getArgument(i).getType().getName());
			sb.append(" ");
			sb.append(getArgument(i).getName());
		}
		sb.append(")");
		sb.append(" {");
		return new String(sb);
	}

    public void implement() {
    }

}
