/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.bcel;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;

import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoXmlUtil;

/**
 * Apache Jakarta BCELp JavaNXt@CXMLeLXgɕϊ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoBcelJavaClass2Xml {
    /**
     * fobO[hœ삳邩ǂB<br>
     * fobO[h̏ꍇAIWisf[^XMLo͂܂B
     */
    private static final boolean IS_DEBUG = false;

    /**
     * classt@C͂ BCEL͌ʂo͂܂B
     * 
     * @param sourceFileName
     *            \[Xt@C
     * @param outFileBcel
     *            BCELo͂t@C
     * @throws IOException
     *             o͗OꍇB
     */
    public final void process(final String sourceFileName,
            final File outFileBcel) throws IOException {
        if (sourceFileName == null) {
            throw new IllegalArgumentException(
                    "Classt@C͂XML鏈ɂāA̓NXt@Cnull^܂B");
        }
        if (new File(sourceFileName).exists() == false) {
            throw new IllegalArgumentException(
                    "Classt@C͂XML鏈ɂāA̓NXt@C[" + sourceFileName
                            + "]܂łB");
        }

        final JavaClass javaClass = new ClassParser(sourceFileName).parse();

        final Document document = BlancoXmlUtil.newDocument();
        final Element elementRoot = document.createElement("blancoBcel");
        document.appendChild(elementRoot);

        /**
         * NX̏܂B
         */
        processClass(javaClass, document);

        /**
         * tB[h̏܂B
         */
        processField(javaClass, document);

        final Element elementMethods = document.createElement("Methods");
        document.getDocumentElement().appendChild(elementMethods);

        final Method[] methods = javaClass.getMethods();
        for (int indexMethod = 0; indexMethod < methods.length; indexMethod++) {
            /**
             * \bh̏܂B
             */
            processMethod(javaClass, methods[indexMethod], document,
                    elementMethods);
        }

        BlancoXmlUtil.transformDom2File(document, outFileBcel);
    }

    /**
     * NXѐeNX^ꂽC^[ɏo͂܂B
     * 
     * @param javaClass
     *            BCELJavaClassIuWFNg
     * @param document
     *            o͐XMLhLg
     * @throws IOException
     *             o͗OꍇB
     */
    private void processClass(final JavaClass javaClass, final Document document)
            throws IOException {
        final Element eleClass = document.createElement("Class");
        document.getDocumentElement().appendChild(eleClass);

        BlancoXmlUtil.addChildElement(document, eleClass, "Name", javaClass
                .getClassName());
        BlancoXmlUtil.addChildElement(document, eleClass, "SuperclassName",
                javaClass.getSuperclassName());

        final String[] interfaceNames = javaClass.getInterfaceNames();
        for (int index = 0; index < interfaceNames.length; index++) {
            BlancoXmlUtil.addChildElement(document, eleClass, "InterfaceName",
                    interfaceNames[index]);
        }

        document.getDocumentElement()
                .appendChild(document.createTextNode("\n"));
    }

    /**
     * NX̒ static final ȃtB[h񋓂܂B
     * 
     * @param javaClass
     *            BCELJavaClassIuWFNg
     * @param document
     *            o͐XMLhLg
     * @throws IOException
     *             o͗OꍇB
     */
    private void processField(final JavaClass javaClass, final Document document)
            throws IOException {
        final Element eleFields = document.createElement("Fields");
        document.getDocumentElement().appendChild(eleFields);

        final Field[] fields = javaClass.getFields();
        for (int index = 0; index < fields.length; index++) {
            if (fields[index].isFinal() == false) {
                // final̓XLbv܂B
                continue;
            }
            if (fields[index].isStatic() == false) {
                // static̓XLbv܂B
                continue;
            }

            final Element eleField = document.createElement("ConstantField");
            eleFields.appendChild(eleField);

            BlancoXmlUtil.addChildElement(document, eleField, "Name",
                    fields[index].getName());
            BlancoXmlUtil.addChildElement(document, eleField, "Value",
                    fields[index].getConstantValue().toString());
        }

        document.getDocumentElement()
                .appendChild(document.createTextNode("\n"));
    }

    /**
     * \bhу\bh̓e^ꂽC^[ɏo͂܂B
     * 
     * @param javaClass
     *            BCELJavaClassIuWFNg
     * @param method
     *            BCEL̃\bhIuWFNg
     * @param document
     *            o͐XMLhLg
     * @throws IOException
     *             o͗OꍇB
     */
    private void processMethod(final JavaClass javaClass, final Method method,
            final Document document, final Element elementMethods)
            throws IOException {
        final Element eleMethod = document.createElement("Method");
        elementMethods.appendChild(eleMethod);

        BlancoXmlUtil.addChildElement(document, eleMethod, "Name", method
                .getName());

        final Type[] argumentTypes = method.getArgumentTypes();
        for (int indexArgument = 0; indexArgument < argumentTypes.length; indexArgument++) {
            BlancoXmlUtil.addChildElement(document, eleMethod, "Argument",
                    argumentTypes[indexArgument].getSignature());
        }

        BlancoXmlUtil.addChildElement(document, eleMethod, "Return", method
                .getReturnType().getSignature());

        eleMethod.appendChild(document.createTextNode("\n"));

        final Element eleLines = document.createElement("Lines");
        eleMethod.appendChild(eleLines);

        final Code code = method.getCode();
        if (code == null) {
            /**
             * R[hꍇɂ͏f܂B
             */
            return;
        }

        /**
         * \bĥȂ̃oCgR[hC^[ɏo͂܂B <br>
         * ɍۂVerbose[hOFFɂĂ܂B
         */
        final String result = Utility.codeToString(code.getCode(), javaClass
                .getConstantPool(), 0, -1, false);
        final BufferedReader reader = new BufferedReader(new StringReader(
                result));
        for (;;) {
            final String line = reader.readLine();
            if (line == null) {
                break;
            }

            eleLines.appendChild(document.createTextNode("\n "));
            final Element eleLine = document.createElement("Line");
            eleLines.appendChild(eleLine);

            final String[] splitedWithKolon = BlancoNameUtil.splitString(line,
                    ':');
            if (splitedWithKolon.length < 2) {
                throw new IllegalArgumentException("sf[^̎擾ɕsȒl(" + line
                        + ") ̐(" + splitedWithKolon.length
                        + ")߂܂Bf܂B");
            }

            eleLine.appendChild(document.createTextNode("\n  "));
            BlancoXmlUtil.addChildElement(document, eleLine, "Number",
                    splitedWithKolon[0]);

            eleLine.appendChild(document.createTextNode("\n  "));
            final String[] splitedWithTab = BlancoNameUtil.splitString(
                    splitedWithKolon[1], '\t');
            final String operation = splitedWithTab[0].trim();

            BlancoXmlUtil.addChildElement(document, eleLine, "Operation",
                    operation);
            eleLine.appendChild(document.createTextNode("\n  "));

            String operand = line;
            for (boolean isTabFound = false; operand.length() > 0; operand = operand
                    .substring(1)) {
                if (isTabFound == false) {
                    // tabłB
                    if (operand.charAt(0) == '\t') {
                        // tab܂
                        isTabFound = true;
                    }
                } else {
                    // 擪 ܂B
                    if (operand.charAt(0) == '\t') {
                        // s
                    } else {
                        // Ŋ]̉ӏɓBĂ܂B
                        break;
                    }
                }
            }
            BlancoXmlUtil
                    .addChildElement(document, eleLine, "Operand", operand);

            if (IS_DEBUG) {
                eleLine.appendChild(document.createTextNode("\n  "));
                BlancoXmlUtil.addChildElement(document, eleLine,
                        "DebugOriginalLine", line);
            }

            eleLine.appendChild(document.createTextNode("\n "));
        }

        eleMethod.appendChild(document.createTextNode("\n"));
    }
}
