/*
 * blancoResourceBundle Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.resourcebundle.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import org.apache.tools.ant.BuildException;

import blanco.resourcebundle.BlancoResourceBundleMeta2Xml;
import blanco.resourcebundle.BlancoResourceBundleXml2CombinedXml;
import blanco.resourcebundle.BlancoResourceBundleXml2JavaClass;
import blanco.resourcebundle.BlancoResourceBundleXml2Properties;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * BlancoResourceBundle Ant Task
 */
public class BlancoResourceBundleTask extends AbstractBlancoResourceBundleTask {
    private final BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    protected void process() throws IllegalArgumentException {
        try {
            final File blancoTmpResourceBundleDirectory = new File(getTmpdir()
                    + "/resourcebundle");
            blancoTmpResourceBundleDirectory.mkdirs();

            File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new BuildException(bundle.getTaskErr001(getMetadir()));
            }
            final File[] fileMeta = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta.length; index++) {
                if (fileMeta[index].getName().endsWith(".xls") == false) {
                    continue;
                }
                final File fileTmpTarget = new File(
                        blancoTmpResourceBundleDirectory + "/"
                                + fileMeta[index].getName() + ".xml");
                final File fileTmpTargetCombine = new File(
                        blancoTmpResourceBundleDirectory + "/"
                                + fileMeta[index].getName() + ".combinedxml");

                InputStream inStream = null;
                OutputStream outStream = null;
                try {
                    inStream = new BufferedInputStream(new FileInputStream(
                            fileMeta[index]));
                    outStream = new BufferedOutputStream(new FileOutputStream(
                            fileTmpTarget));
                    new BlancoResourceBundleMeta2Xml().process(inStream,
                            outStream);
                    outStream.flush();
                } finally {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                // XMLt@Cgݑւ܂B
                new BlancoResourceBundleXml2CombinedXml().process(
                        fileTmpTarget, fileTmpTargetCombine);
            }

            final File[] fileTmp = blancoTmpResourceBundleDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".combinedxml")) {
                    new BlancoResourceBundleXml2JavaClass().process(
                            fileTmp[index], new File(getTargetdir()));
                } else if (fileTmp[index].getName().endsWith(".xml")) {
                    final BlancoResourceBundleXml2Properties xml2properties = new BlancoResourceBundleXml2Properties();
                    xml2properties.setCommentTimestamp(getCommenttimestamp()
                            .equals("true"));
                    xml2properties.process(fileTmp[index], new File(
                            getTargetdir() + "/main"));
                }
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }
}
