/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.anttask;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.anttask.resourcebundle.BlancoAntTaskResourceBundle;
import blanco.commons.calc.parser.BlancoCalcParser;

/**
 * ^(xlst@C)璆ԃt@CłXML쐬܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoAntTaskMeta2Xml {
    private final BlancoAntTaskResourceBundle bundle = new BlancoAntTaskResourceBundle();

    /**
     * Excelt@C𒆊XMLt@Cɕϊ܂B
     * 
     * ϊ̂߂ blancoCalcParser`t@C݂̏ɂāA\[Xoh`ɃpXLڂĂ܂B
     * 
     * @param inStreamMetaSource
     *            ^t@C̓̓Xg[
     * @param outStreamTarget
     *            ԃt@Cւ̏o̓Xg[
     * @throws IOException
     *             o͗Oꍇ
     * @throws TransformerException
     *             XMLϊOꍇ
     */
    public void process(final InputStream inStreamMetaSource,
            final OutputStream outStreamTarget) throws IOException,
            TransformerException {
        InputStream inStreamDef = null;
        try {
            inStreamDef = new BufferedInputStream(getClass().getClassLoader()
                    .getResourceAsStream(bundle.getBlancoAnttaskMeta2xmlpath()));
            new BlancoCalcParser().process(inStreamDef, inStreamMetaSource,
                    outStreamTarget);
        } finally {
            if (inStreamDef != null)
                inStreamDef.close();
        }
    }
}