/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.bcel;

import java.io.File;

import junit.framework.TestCase;

/**
 * BlancoBcelJavaClass2XmlJUnitNXB
 * 
 * ̃NXg BlancoJUnit̃TvɂȂĂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoBcelJavaClass2XmlTest extends TestCase {
    /**
     * ΏۂƂȂĂUpbP[WƂȂNX܂B
     */
    private static final String TARGET_NAME = "blanco.bcel.BlancoBcelJavaClass2Xml";

    /**
     * ͂sNXt@Cw肵܂B<br>
     * ȂA̗ł͎gw肵Ă܂B
     */
    private static final String TARGET_CLASS_JUNIT = "./bin/blanco/bcel/BlancoBcelJavaClass2XmlTest.class";

    protected void setUp() throws Exception {
        super.setUp();
        // fBNg܂B
        new File("./tmp").mkdirs();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testProcess01() throws Exception {
        // \bh̍ŏ̉ӏɂāAΏۂɊւe܂B
        // RX^g [Ώ]JnꍇɁAhLgւ̘As܂B
        final String TARGET = "[Ώ]BlancoBcel̐n̋ɂĂ̊mFB";

        new BlancoBcelJavaClass2Xml().process(TARGET_CLASS_JUNIT, new File(
                "./tmp/aaa.xml"));
        // RX^g []JnꍇɁAhLgւ̘As܂B
        assertTrue("[][n]BlancoBcel̐nK؂ɓ삷邱ƂmFB", true);
    }

    public void testProcess02() throws Exception {
        // \bh̍ŏ̉ӏɂāAΏۂɊւe܂B
        // RX^g [Ώ]JnꍇɁAhLgւ̘As܂B
        final String TARGET = "[Ώ]BlancoBcelُ̈n̋ɂĂ̊mFB";

        try {
            new BlancoBcelJavaClass2Xml().process(null, new File(
                    "./tmp/aaa.xml"));
            fail("O܂łBf܂B");
        } catch (IllegalArgumentException ex) {
            // RX^g []JnꍇɁAhLgւ̘As܂B
            assertTrue(
                    "[][ُn]BlancoBcel̓̓NXnullnꍇɁAIllegalArgumentExceptionOƂȂĈُI邱ƂmFB",
                    true);
        }

        try {
            new BlancoBcelJavaClass2Xml().process(TARGET_CLASS_JUNIT, null);
            fail("O܂łBf܂B");
        } catch (IllegalArgumentException ex) {
            // RX^g []JnꍇɁAhLgւ̘As܂B
            assertTrue(
                    "[][ُn]BlancoBcel̏o͐nullnꍇɁAIllegalArgumentExceptionOƂȂĈُI邱ƂmFB",
                    true);
        }
    }

    public void testProcess03() throws Exception {
        // \bh̍ŏ̉ӏɂāAΏۂɊւe܂B
        // RX^g [Ώ]JnꍇɁAhLgւ̘As܂B
        final String TARGET = "[Ώ]BlancoBcelp͂̋ɂĂ̊mFB";

        String value = "";
        value += "l";

        // RX^g []JnꍇɁAhLgւ̘As܂B
        assertEquals(
                "[][n] \"\"  \"l\" ƂʁARX^gʂ l\"Ғl\" ɂȂ邱ƂmFB",
                "Ғl", value);
    }
}
