/*
 * blanco Framework Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.opendocument;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import blanco.commons.util.BlancoFileUtil;

/**
 * ۓIZIPt@C̕ҏW@\NXBۂɗpꍇɂ͌pėpĂB
 * 
 * @author IGA Tosiki
 */
public abstract class AbstractZipEditor {
    /**
     * ZIPGg[s邽тɔCxgB<br>
     * ̒ۃ\bhĎۂ̏Lq܂B
     * 
     * @param entryName
     *            Gg[
     * @param inStream
     *            ̓Xg[
     * @param outStream
     *            o̓Xg[
     * @return ǂ falseȂftHg̋łXg[Rs[IɎsB
     */
    protected abstract boolean processEntry(final String entryName,
            final InputStream inStream, final OutputStream outStream)
            throws IOException;

    /**
     * ^ꂽlg ZIPt@CXV܂B<br>
     * ݂̔łłCRCG[`FbN͏ȗĂ܂B
     * 
     * @param fileSource
     * @param fileTarget
     *            nullw肵ꍇɂ͓ǂݍݏ݂̂{܂B
     * @throws IOException
     */
    public final void process(final File fileSource, final File fileTarget)
            throws IOException {
        if (fileSource == null) {
            throw new IllegalArgumentException("̓t@Cnullw肳܂B");
        }
        if (fileSource.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ̓t@C["
                    + fileSource.getAbsolutePath() + "]݂͑܂B");
        }
        if (fileSource.isDirectory()) {
            throw new IllegalArgumentException("w肳ꂽ̓t@C["
                    + fileSource.getAbsolutePath() + "]̓fBNgłB");
        }
        if (fileTarget != null) {
            if (fileTarget.exists() && fileTarget.canWrite() == false) {
                throw new IllegalArgumentException("w肳ꂽo̓t@C["
                        + fileTarget.getAbsolutePath() + "]݂A݂ł܂B");
            }
            if (fileTarget.isDirectory()) {
                throw new IllegalArgumentException("w肳ꂽo̓t@C["
                        + fileTarget.getAbsolutePath() + "]̓fBNgłB");
            }
        }

        ZipInputStream inStream = null;
        ZipOutputStream outStream = null;
        try {
            inStream = new ZipInputStream(new BufferedInputStream(
                    new FileInputStream(fileSource)));
            if (fileTarget != null) {
                // fileTargetnullȊȌꍇɂ̂݃I[v܂B
                outStream = new ZipOutputStream(new BufferedOutputStream(
                        new FileOutputStream(fileTarget)));
            }

            // ۂ̃Xg[s܂B
            processStreamInternal(inStream, outStream);

            if (outStream != null) {
                outStream.flush();
            }
        } finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            } finally {
                if (outStream != null) {
                    outStream.close();
                }
            }
        }
    }

    /**
     * ZIPo̓Xg[gt@C̎S܂B
     * 
     * @param inStream
     *            ̓Xg[B
     * @param outStream
     *            o͐̃Xg[Bnullw肳ꂽꍇɂ͏o͏͍s܂B
     * @throws IOException
     */
    private void processStreamInternal(final ZipInputStream inStream,
            final ZipOutputStream outStream) throws IOException {
        for (boolean isZipEntryFound = false;; isZipEntryFound = true) {
            final ZipEntry entry = inStream.getNextEntry();
            try {
                if (entry == null) {
                    if (isZipEntryFound == false) {
                        throw new IOException("ZIPGg1܂łB");
                    }
                    break;
                }

                // ̂̂ZIPGg[܂B
                processEveryZipEntryInternal(inStream, entry, outStream);
            } finally {
                inStream.closeEntry();

                if (outStream != null) {
                    outStream.closeEntry();
                }
            }
        }
    }

    /**
     * ̂̂ZIPGg[܂B
     * 
     * @param inStream
     * @param entry
     * @param outStream
     * @throws IOException
     */
    private void processEveryZipEntryInternal(final ZipInputStream inStream,
            final ZipEntry entry, final ZipOutputStream outStream)
            throws IOException {
        if (outStream != null) {
            outStream.putNextEntry(entry);
        }

        if (entry.isDirectory() == false) {
            // t@Cł邱Ƃŏ̏ł
            // ƂƂ̃t@CȂƏł܂B

            if (processEntry(entry.getName(), inStream, outStream)) {
                // s܂B
            } else {
                // Ȃt@CłBWXƃRs[sĂ܂B
                if (outStream != null) {
                    BlancoFileUtil.copy(inStream, outStream);
                }
            }
        } else {
            // WXƃRs[sĂ܂B
            if (outStream != null) {
                BlancoFileUtil.copy(inStream, outStream);
            }
        }
    }
}
