/*
 * blancoCommons Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.commons.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;

/**
 * blanco Framework̖Oό`Ɋւ郆[eBeBłB
 * 
 * @author IGA Tosiki
 */
public class BlancoNameAdjuster {
    /**
     * ׂł邩ǂ<br>
     * blanco FrameworkƂ JavãNX⃁\bhƂĕsK؂ȕ`Ă܂B
     * 
     * @param arg
     * @return
     */
    public static final boolean checkAdjustChar(final char arg) {
        switch (arg) {
        case '!':
        case '"':
        case '#':
        case '%':
        case '&':
        case '\'':
        case '(':
        case ')':
        case '-':
        case '=':
        case '^':
        case '~':
        case '\\':
        case '|':
        case '@':
        case '[':
        case ']':
        case '{':
        case '}':
        case ';':
        case '+':
        case ':':
        case '*':
        case '<':
        case '>':
        case ',':
        case '.':
        case '/':
        case '?':
        case '_':
        case ' ':
            return true;
        default:
            return false;
        }
    }

    /**
     * ׂ܂܂Ă邩ǂ<br>
     * blanco FrameworkƂ JavãNX⃁\bhƂĕsK؂ȕ`Ă܂B
     * 
     * @param arg
     * @return
     */
    public static final boolean checkAdjustCharExist(final String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(
                    "񂪊܂܂邩ǂ`FbN郁\bh (BlancoNameAdjuster.checkAdjustCharExist) null^܂Ã\bhnull^邱Ƃ͂ł܂B");
        }

        for (int index = 0; index < arg.length(); index++) {
            if (checkAdjustChar(arg.charAt(index))) {
                return true;
            }
        }
        return false;
    }

    /**
     * ^ꂽɂāA擪̕啶ɂȂ悤ɕό`܂B
     * 
     * @param arg
     *            nullȊO̕B0̕^邱Ƃ͋܂B
     * @return ό`̕
     */
    public static final String toUpperCaseTitle(final String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(
                    "̐擪啶ɕϊ郋[`null^܂B");
        }
        if (arg.length() == 0) {
            // 0̕ɂẮAe܂B
            return arg;
        }
        final char[] buf = arg.toCharArray();
        if (buf[0] != Character.toUpperCase(buf[0])) {
            // 擪啶ɂ܂B
            buf[0] = Character.toUpperCase(buf[0]);
            return new String(buf);
        } else {
            return arg;
        }
    }

    /**
     * ^ꂽɂāA擪̕ɂȂ悤ɕό`܂B<br>
     * p[^Ȃǂɗp܂B
     * 
     * @param arg
     * @return
     */
    public static final String toLowerCaseTitle(final String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(
                    "̐擪ɕϊ郋[`null^܂B");
        }
        if (arg.length() == 0) {
            throw new IllegalArgumentException(
                    "̐擪ɕϊ郋[`ɒ0̕񂪗^܂B");
        }
        final char[] buf = arg.toCharArray();
        if (buf[0] != Character.toLowerCase(buf[0])) {
            // 擪啶ɂ܂B
            buf[0] = Character.toLowerCase(buf[0]);
            return new String(buf);
        } else {
            return arg;
        }
    }

    /**
     * ^ꂽSđ啶łꍇɂ́A擪ȊOɕϊ܂B<br>
     * ̍ŏ(̏O̖{̍ŏ)ɁÃ\bhʉ߂邱Ƃz肵Ă܂B
     * 
     * @param arg
     * @return
     */
    public static final String weakenUpperCase(final String arg) {
        if (arg.equals(arg.toUpperCase())) {
            // ^ꂽ񂪊ɑ啶łB
            // 啶LĉŁA߁A擪݂̂啶ɂȂ悤ɕϊ܂B
            return toUpperCaseTitle(arg.toLowerCase());
        } else {
            return arg;
        }
    }

    /**
     * ^ꂽAׂɊւĒႵĕ܂<br>
     * ̌ʁA0̕߂ꍇ_ɒӂĂB
     * 
     * @param arg
     * @return
     */
    public static final String[] splitByAdjustChar(final String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(
                    "Ƃɕ𕪊郁\bh (BlancoNameAdjuster.splitByAdjustChar) null^܂Ã\bhnull^邱Ƃ͂ł܂B");
        }

        final ArrayList result = new ArrayList();
        final char[] bufRead = arg.toCharArray();
        final CharArrayWriter writerWork = new CharArrayWriter();
        for (int index = 0; index < bufRead.length; index++) {
            if (checkAdjustChar(bufRead[index])) {
                // ׂłB
                writerWork.flush();
                result.add(weakenUpperCase(writerWork.toString()));
                writerWork.reset();
            } else {
                writerWork.write(bufRead[index]);
            }
        }
        writerWork.flush();
        result.add(weakenUpperCase(writerWork.toString()));
        final String[] ret = new String[result.size()];
        return (String[]) result.toArray(ret);
    }

    /**
     * ^ꂽ Ǝ̖Oό`[ɏ]ăNXƂĉH܂B<br>
     * ȂÃ\bh̖߂l̂A擪ɉHƃtB[hւƕό`܂B
     * 
     * @param arg
     * @return
     */
    public static final String toClassName(final String arg) {
        final StringWriter result = new StringWriter();
        // 啶ꍇɂ́A߂Ŗ߂܂B
        final String[] work = splitByAdjustChar(arg);
        for (int index = 0; index < work.length; index++) {
            if (work[index].length() == 0) {
                // 0̏ꍇ͏XLbv܂B
                continue;
            }
            // g[Nɐ擪啶ɕό`܂B
            result.write(toUpperCaseTitle(work[index]));
        }
        try {
            result.close();
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "NXɒ郋[`ɂāA͂̂ȂO܂B:" + e.toString());
        }
        return result.toString();
    }

    /**
     * ^ꂽ Ǝ̖Oό`[ɏ]ăp[^ƂĉH܂B<br>
     * ۂɂ toClassNameŁA擪ɕό`Ă܂B
     * 
     * @param arg
     * @return
     */
    public static final String toParameterName(final String arg) {
        return toLowerCaseTitle(toClassName(arg));
    }
}
