/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.test.valueobject.method;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;
import blanco.test.valueobject.resourcebundle.BlancoValueObjectTestResourceBundle;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * String^̃tB[ĥ߂JUnitpJava\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JUnitPrimitiveLongMethod extends
        MethodExpander {
    private final BlancoValueObjectTestResourceBundle bundle = new BlancoValueObjectTestResourceBundle();

    private BlancoValueObjectClassStructure classInfo = null;

    private BlancoValueObjectFieldStructure field = null;

    /**
     * String^̃tB[h邽߂̃\bhNX̃RXgN^
     * 
     * @param arg
     *            \bh
     * @param classStructure
     *            ݏ̃NX\
     * @param fieldInfo
     *            ݏ̃tB[h
     */
    public BlancoValueObjectXml2JUnitPrimitiveLongMethod(final String arg,
            final BlancoValueObjectClassStructure classStructure,
            final BlancoValueObjectFieldStructure fieldInfo) {
        super(arg);
        classInfo = classStructure;
        field = fieldInfo;
    }

    /**
     * \bh̃VOj`w
     */
    public void setupSignature() {
        addException(new Type("java.lang.Exception"));
        getJavaDoc().addLine(bundle.getMethodJavadoc001(field.getName()));
        getJavaDoc().addLine(
                bundle.getMethodJavadoc002(classInfo.getName(),
                        field.getName(), field.getType()));
    }

    /**
     * \bh̎
     */
    public void implement() {
        final String fieldNameAdjustered = BlancoNameAdjuster.toClassName(field
                .getName());

        getData().addLine(bundle.getMethodPrimitiveLongB01L01());
        getData().addLine(
                bundle.getMethodPrimitiveLongB01L02(classInfo.getName()));
        getData().addLine(bundle.getMethodPrimitiveLongB01L03());

        if (field.getDefault() == null) {
            getData().addLine(bundle.getMethodPrimitiveLongB02L01());
            getData().addLine(
                    bundle.getMethodPrimitiveLongB02L02(classInfo.getName(),
                            field.getName(), fieldNameAdjustered));
        } else {
            getData().addLine(bundle.getMethodPrimitiveLongB03L01());
            getData().addLine(
                    bundle.getMethodPrimitiveLongB03L02(classInfo.getName(),
                            field.getName(), field.getDefault(),
                            BlancoJavaSourceUtil.escapeStringAsJavaSource(field
                                    .getDefault()), fieldNameAdjustered));
        }
        getData().addLine(bundle.getMethodPrimitiveLongB03L03());

        getData().addLine(bundle.getMethodPrimitiveLongB04L01());
        getData().addLine(
                bundle.getMethodPrimitiveLongB04L02(fieldNameAdjustered));
        getData().addLine(
                bundle.getMethodPrimitiveLongB04L03(classInfo.getName(), field
                        .getName(), fieldNameAdjustered));
        getData().addLine(bundle.getMethodPrimitiveLongB04L04());

        getData().addLine(bundle.getMethodPrimitiveLongB05L01());
        getData().addLine(
                bundle.getMethodPrimitiveLongB05L02(fieldNameAdjustered));
        getData().addLine(
                bundle.getMethodPrimitiveLongB05L03(classInfo.getName(), field
                        .getName(), fieldNameAdjustered));
        getData().addLine(bundle.getMethodPrimitiveLongB05L04());

        getData().addLine(bundle.getMethodPrimitiveLongB06L01());
        getData().addLine(
                bundle.getMethodPrimitiveLongB06L02(fieldNameAdjustered));
        getData().addLine(
                bundle.getMethodPrimitiveLongB06L03(classInfo.getName(), field
                        .getName(), fieldNameAdjustered));
        getData().addLine(bundle.getMethodPrimitiveLongB06L04());
    }
}
