/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.dbee.editors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.xml.sax.SAXException;

import blanco.plugin.dbee.BlancoDbEEPlugin;
import blanco.plugin.dbee.actions.BlancoDbEEGenerateAction;
import blanco.plugin.dbee.concretesax.BlancoDbBlancoFwHandler;
import blanco.plugin.dbee.concretesax.BlancoDbBlancoFwSerializer;

/**
 * blancoDbGfB^ <br>
 * 
 * @author iga
 */
public class BlancoDbEEEditor extends TextEditor {

    private Composite top = null;

    public static final String TARGET_FILENAME = "blancodb.blancofw";

    public static final String BLANCO_DB_META_FILE = "SQL`";

    // rWÄ
    private Text textBlancoDbSettingId = null;

    private Combo comboJdbcdriver = null;

    private Combo comboJdbcurl = null;

    private Combo comboJdbcuser = null;

    private Text textJdbcpassword = null;

    private Combo comboBasepackage = null;

    private Combo comboMetadir = null;

    private Combo comboSchema = null;

    private Button checkBoxTable = null;

    private Button checkBoxSql = null;

    private Button checkBoxLogging = null;

    public BlancoDbEEEditor() {
        // GR[fBO𑀍삷邽߂ɃZbgĂ܂B
        setDocumentProvider(new BlancoDbEEDocumentProvider());
    }

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelBlancoDbTitle = new Label(top, SWT.NONE);
        labelBlancoDbTitle.setText("BlancoDbݒt@C GfB^");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelBlancoDbSettingId = new Label(top, SWT.NONE);
        labelBlancoDbSettingId.setText("BlancoDbݒID");
        textBlancoDbSettingId = new Text(top, SWT.BORDER);
        textBlancoDbSettingId.setText("blancoDbݒ");
        textBlancoDbSettingId.setEditable(false);
        Label labelJdbcdriver = new Label(top, SWT.NONE);
        labelJdbcdriver.setText("JDBChCo");
        createComboJdbcdriver();
        Label labelJdbcurl = new Label(top, SWT.NONE);
        labelJdbcurl.setText("URL");
        createComboJdbcurl();
        Label labelJdbcuser = new Label(top, SWT.NONE);
        labelJdbcuser.setText("[U");
        createComboJdbcuser();
        Label labelJdbcpassword = new Label(top, SWT.NONE);
        labelJdbcpassword.setText("pX[h");
        textJdbcpassword = new Text(top, SWT.BORDER | SWT.PASSWORD);
        Label labelBasepackage = new Label(top, SWT.NONE);
        labelBasepackage.setText("pbP[W");
        createComboBasepackage();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelPackageComment = new Label(top, SWT.NONE);
        labelPackageComment.setText("pbP[Ww肵ĂB");

        Label labelMetadir = new Label(top, SWT.NONE);
        labelMetadir.setText("^fBNg");
        createComboMetadir();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelMetadirComment = new Label(top, SWT.NONE);
        labelMetadirComment.setText("^fBNg͒ʏύXɗp܂B");

        Label labelSchema = new Label(top, SWT.NONE);
        labelSchema.setText("XL[}");
        createComboSchema();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Button buttonConnectionCheck = new Button(top, SWT.NONE);
        buttonConnectionCheck.setText("ڑ`FbN");
        buttonConnectionCheck
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }
                        try {
                            checkConnectionSetting(comboJdbcdriver.getText(),
                                    comboJdbcurl.getText(), comboJdbcuser
                                            .getText(), textJdbcpassword
                                            .getText(), true);
                        } catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Button buttonCreateMetafile = new Button(top, SWT.NONE);
        buttonCreateMetafile.setText("SQL` VK쐬");
        buttonCreateMetafile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetadir.getText().length() == 0) {
                            MessageDialog
                                    .openWarning(
                                            top.getShell(),
                                            BLANCO_DB_META_FILE + " VK쐬",
                                            "^fBNgw肵ĂB\n"
                                                    + "^fBNg̈ʓIȐݒl 'meta/sql' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoDbEEPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetadir.getText()).exists() == false) {
                                BlancoDbEEPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetadir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetadir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(),
                                    BLANCO_DB_META_FILE + " VK쐬",
                                    "^fBNg쐬Ɏs܂Bf܂B:"
                                            + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        try {
                            URL localURL = getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), BLANCO_DB_META_FILE + " VK쐬",
                                    BLANCO_DB_META_FILE + "(^t@C)^fBNg["
                                            + comboMetadir.getText()
                                            + "]ɍ쐬܂B" + BLANCO_DB_META_FILE
                                            + "̐VKt@C͂ĂB",
                                    "blancoDbMeta.xls", new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetadir
                                                                    .getText())
                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            InputStream inStream = new FileInputStream(localURL
                                    .getPath()
                                    + "/meta/sql/template/blancoDbTemplate.xls");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetadir.getText()).getFile(
                                            newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            inStream.close();
                            MessageDialog
                                    .openInformation(
                                            top.getShell(),
                                            BLANCO_DB_META_FILE + " VK쐬",
                                            BLANCO_DB_META_FILE
                                                    + "["
                                                    + newMetaFilename
                                                    + "] ^fBNg["
                                                    + comboMetadir.getText()
                                                    + "]ɐVK쐬܂B\n"
                                                    + "̃t@CҏWāASQLъ֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Button buttonExecute = new Button(top, SWT.NONE);
        buttonExecute.setText("\[XR[h");
        buttonExecute
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }
                            if (checkConnectionSetting(comboJdbcdriver
                                    .getText(), comboJdbcurl.getText(),
                                    comboJdbcuser.getText(), textJdbcpassword
                                            .getText(), false) == false) {
                                return;
                            }

                            BlancoDbEEGenerateAction.processBlancoDb(
                                    ((IFileEditorInput) getEditorInput())
                                            .getFile(), top.getShell(),
                                    getProgressMonitor(), comboMetadir
                                            .getText(), comboJdbcdriver
                                            .getText(), comboJdbcurl.getText(),
                                    comboJdbcuser.getText(), textJdbcpassword
                                            .getText(), comboSchema.getText(),
                                    comboBasepackage.getText(), checkBoxTable
                                            .getSelection(), checkBoxSql
                                            .getSelection(), checkBoxLogging
                                            .getSelection());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        }
                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Group group = new Group(top, SWT.NONE);
        group.setLayout(new FillLayout());
        group.setText("\[XR[hIvV");
        checkBoxTable = new Button(group, SWT.CHECK);
        checkBoxTable.setText("P\");
        checkBoxTable.setSelection(true);
        checkBoxSql = new Button(group, SWT.CHECK);
        checkBoxSql.setText("SQL`");
        checkBoxSql.setSelection(true);
        checkBoxLogging = new Button(group, SWT.CHECK);
        checkBoxLogging.setText("MO");
        checkBoxLogging.setSelection(false);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelPasswordComment = new Label(top, SWT.NONE);
        labelPasswordComment.setText(": eX̐ݒl " + TARGET_FILENAME
                + "t@CɕŊi[܂B");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        Label labelPasswordComment2 = new Label(top, SWT.NONE);
        labelPasswordComment2.setText("ZLeBvmFēK؂ȑΏȂĂB");

        loadFromTextEditor();

        // tH[JXۂ̏B
        setFocusLostHandler(comboJdbcdriver);
        setFocusLostHandler(comboJdbcurl);
        setFocusLostHandler(comboJdbcuser);
        setFocusLostHandler(textJdbcpassword);
        setFocusLostHandler(comboBasepackage);
        setFocusLostHandler(comboMetadir);
        setFocusLostHandler(comboSchema);
        setFocusLostHandler(checkBoxTable);
        setFocusLostHandler(checkBoxSql);
        setFocusLostHandler(checkBoxLogging);
    }

    /**
     * ڑݒʂɐڑ\ǂ𒲂ׂ܂B
     * 
     * @throws IOException
     * 
     */
    private boolean checkConnectionSetting(final String jdbcdriver,
            final String jdbcurl, final String jdbcuser,
            final String jdbcpassword, final boolean isReportSuccess)
            throws IOException {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            monitor.beginTask("ڑ`FbNȂ܂B", 5);
                            monitor.worked(1);
                            try {
                                Class.forName(jdbcdriver);
                                monitor.worked(1);
                                Connection conn = DriverManager.getConnection(
                                        jdbcurl, jdbcuser, jdbcpassword);
                                monitor.worked(1);
                                conn.close();
                                monitor.worked(1);
                            } catch (Exception e) {
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                throw new InvocationTargetException(e, e
                                        .toString());
                            }
                        }
                    });
            if (isReportSuccess) {
                MessageDialog
                        .openInformation(top.getShell(), "ڑ`FbN",
                                "f[^x[Xւ̐ڑɐ܂.\n݂̐ݒŃf[^x[Xɐڑ\ł邱ƂmFł܂B");
            }
            return true;
        } catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                MessageDialog.openWarning(top.getShell(), "ڑ`FbNs",
                        "ڑɎs܂B\n"
                                + "ɂ܂ݒlA[UEpX[hȂǂmFĂB\n\n"
                                + cause.toString());
            } else if (cause instanceof ClassNotFoundException) {
                MessageDialog
                        .openWarning(
                                top.getShell(),
                                "ڑ`FbNs",
                                "wJDBChCo("
                                        + comboJdbcdriver.getText()
                                        + ")̓ǂݍ݂Ɏs܂B\n\n"
                                        + "JDBChCoǂݍ߂悤ɒsKv\܂B\n"
                                        + "BlancoDbEEPluginvOC̃tH_̉L̉ӏ𒲍ĂB\n"
                                        + "  tH_ ["
                                        + getPluginRoot().getPath()
                                        + "] vOC̃tH_ł\n"
                                        + "1.vOC̃Cuݒ\n"
                                        + "  META-INF/MANIFEST.MFt@C Bundle-ClassPathGg \n"
                                        + "      lib/JDBChCo.jar"
                                        + "    ̋Lڂ邱ƂmF܂B\n"
                                        + "    ꍇɂ͒ǉĂB\n"
                                        + "  uJDBChCo.jarv͎ۂjart@CւƓKXǑւsĂB\n"
                                        + "2.w肵vOCtH_ lib/JDBChCo.jar \n"
                                        + "  ۂɑ݂邱ƂmF܂B\n"
                                        + "  ݗpĂJavavWFNglibtH_ł͂Ȃ_\n"
                                        + "    ӂĂB\n"
                                        + "3.mFIAύX_ꍇɂ ύXEclipse̍ċN\n"
                                        + "  sĂB\n"
                                        + "  ȂAMETA-INF/MANIFEST.MFt@CύXꍇɂ\n"
                                        + "  eclipse -clean̂悤ɃIvVtŋNĂB\n\n"
                                        + cause.toString());
            } else {
                MessageDialog.openWarning(top.getShell(), "ڑ`FbNs",
                        "ڑɎs܂B\n" + "z肵ȂG[܂B\n\n"
                                + cause.toString());
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * vOC̃[gfBNg擾܂B
     * 
     * @return [gfBNgURL getPath()ƃtpXɂȂ܂B
     * @throws IOException
     */
    private URL getPluginRoot() throws IOException {
        URL relativeURL = BlancoDbEEPlugin.getDefault().getBundle().getEntry(
                "/");
        URL localURL = Platform.asLocalURL(relativeURL);
        return localURL;
    }

    private void setFocusLostHandler(Control target) {
        target.addFocusListener(new FocusListener() {
            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                saveToTextEditor();
            }

        });
    }

    public void setFocus() {
    }

    /**
     * Ǎs܂ <br>
     * ̃\bh͏ɖč쐬܂B <br>
     */
    public void loadFromTextEditor() {
        try {
            String editorText = getDocumentProvider().getDocument(
                    getEditorInput()).get();

            SAXResult result = new SAXResult(new BlancoDbBlancoFwHandler() {
                public void startDocument() throws SAXException {
                    comboSchema.setText("");
                }

                public void endDocument() throws SAXException {
                }

                public void startElementBlanco(String uri, String localName,
                        String qName, String attrVersion) throws SAXException {
                }

                public void endElementBlanco(String uri, String localName,
                        String qName) throws SAXException {
                }

                public void charactersBlanco(char[] ch, int start, int length)
                        throws SAXException {
                }

                public void ignorableWhitespaceBlanco(char[] ch, int start,
                        int length) throws SAXException {
                }

                public void startElementTarget(String uri, String localName,
                        String qName, String attrName) throws SAXException {
                }

                public void endElementTarget(String uri, String localName,
                        String qName) throws SAXException {
                }

                public void charactersTarget(char[] ch, int start, int length)
                        throws SAXException {
                }

                public void ignorableWhitespaceTarget(char[] ch, int start,
                        int length) throws SAXException {
                }

                public void startElementBlancodb(String uri, String localName,
                        String qName, String attrJdbcdriver,
                        String attrJdbcurl, String attrJdbcuser,
                        String attrJdbcpassword, String attrBasepackage,
                        String attrMetadir, String attrSchema,
                        String attrTable, String attrSql, String attrLog)
                        throws SAXException {
                    comboJdbcdriver.setText(attrJdbcdriver);
                    comboJdbcurl.setText(attrJdbcurl);
                    comboJdbcuser.setText(attrJdbcuser);
                    textJdbcpassword.setText(attrJdbcpassword);
                    comboBasepackage.setText(attrBasepackage);
                    comboMetadir.setText(attrMetadir);
                    comboSchema.setText(attrSchema == null ? "" : attrSchema);
                    checkBoxTable.setSelection(attrTable.equals("true"));
                    checkBoxSql.setSelection(attrSql.equals("true"));
                    checkBoxLogging.setSelection(attrLog.equals("true"));
                }

                public void endElementBlancodb(String uri, String localName,
                        String qName) throws SAXException {
                    // System.out.println("end: blancodb");
                }

                public void charactersBlancodb(char[] ch, int start, int length)
                        throws SAXException {
                    // System.out.println("characters: blancodb["
                    // + new String(ch, start, length) + "]");
                }

                public void ignorableWhitespaceBlancodb(char[] ch, int start,
                        int length) throws SAXException {
                }

            });

            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(
                    new StreamSource(new StringReader(editorText)), result);
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    /**
     * ۑs܂B
     */
    public void saveToTextEditor() {
        StringWriter writer = new StringWriter();
        try {
            String schema = null;
            if (comboSchema.getText().length() > 0) {
                schema = comboSchema.getText();
            }

            BlancoDbBlancoFwSerializer serializer = new BlancoDbBlancoFwSerializer(
                    writer);
            serializer.startDocument();
            serializer.startElementBlanco("0.1.0");
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementTarget(textBlancoDbSettingId.getText());
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementBlancodb(comboJdbcdriver.getText(),
                    comboJdbcurl.getText(), comboJdbcuser.getText(),
                    textJdbcpassword.getText(), comboBasepackage.getText(),
                    comboMetadir.getText(), schema, (checkBoxTable
                            .getSelection() ? "true" : "false"), (checkBoxSql
                            .getSelection() ? "true" : "false"),
                    (checkBoxLogging.getSelection() ? "true" : "false"));
            serializer.endElementBlancodb();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.endElementTarget();
            serializer.characters("\n");
            serializer.endElementBlanco();
            serializer.endDocument();
            writer.flush();
        } catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        } catch (SAXException ex) {
            ex.printStackTrace();
        }

        String pastEditorText = getDocumentProvider().getDocument(
                getEditorInput()).get();
        if (pastEditorText.equals(writer.toString()) == false) {
            // eقȂꍇɂ̂ݏ݂s܂B
            getDocumentProvider().getDocument(getEditorInput()).set(
                    writer.toString());
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (comboJdbcdriver.getText().length() == 0) {
            comboJdbcdriver.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboJdbcdriver.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboJdbcurl.getText().length() == 0) {
            comboJdbcurl.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboJdbcurl.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboJdbcuser.getText().length() == 0) {
            comboJdbcuser.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboJdbcuser.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboBasepackage.getText().length() == 0) {
            comboBasepackage.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboBasepackage.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (comboMetadir.getText().length() == 0) {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    /**
     * This method initializes comboJdbcdriver
     * 
     */
    private void createComboJdbcdriver() {
        comboJdbcdriver = new Combo(top, SWT.NONE);
        comboJdbcdriver
                .addSelectionListener(new org.eclipse.swt.events.SelectionListener() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {

                        Object source = e.getSource();
                        if (source instanceof Combo) {
                            Combo combo = (Combo) source;
                            if (combo.getText().equals(
                                    "oracle.jdbc.driver.OracleDriver")) {
                                comboJdbcurl
                                        .setText("jdbc:oracle:thin:@localhost:1521:orcl");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("SCOTT");
                                comboSchema.removeAll();
                                comboSchema.add("SCOTT");
                                comboSchema.setText("SCOTT");
                            } else if (combo
                                    .getText()
                                    .equals(
                                            "com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
                                comboJdbcurl
                                        .setText("jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=Northwind;SelectMethod=cursor");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("sa");
                                comboSchema.removeAll();
                            } else if (combo.getText().equals(
                                    "org.postgresql.Driver")) {
                                comboJdbcurl
                                        .setText("jdbc:postgresql://localhost:5432/template1");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("postgres");
                                comboSchema.removeAll();
                            } else if (combo.getText().equals(
                                    "com.mysql.jdbc.Driver")) {
                                comboJdbcurl
                                        .setText("jdbc:mysql://localhost:3306/test?useUnicode=true");
                                comboJdbcuser.removeAll();
                                comboJdbcuser.add("root");
                                comboSchema.removeAll();
                            }
                        }
                    }

                    public void widgetDefaultSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                    }
                });
        comboJdbcdriver.add("oracle.jdbc.driver.OracleDriver");
        comboJdbcdriver.add("com.microsoft.jdbc.sqlserver.SQLServerDriver");
        comboJdbcdriver.add("org.postgresql.Driver");
        comboJdbcdriver.add("com.mysql.jdbc.Driver");
    }

    /**
     * This method initializes comboJdbcurl
     * 
     */
    private void createComboJdbcurl() {
        comboJdbcurl = new Combo(top, SWT.NONE);
    }

    /**
     * This method initializes comboJdbcuser
     * 
     */
    private void createComboJdbcuser() {
        comboJdbcuser = new Combo(top, SWT.NONE);
    }

    /**
     * This method initializes comboBasepackage
     * 
     */
    private void createComboBasepackage() {
        comboBasepackage = new Combo(top, SWT.NONE);
        comboBasepackage.add("myapp.db");
        comboBasepackage.add("mycompany.myapp.db");
        comboBasepackage.select(0);
    }

    /**
     * This method initializes comboMetadir
     * 
     */
    private void createComboMetadir() {
        comboMetadir = new Combo(top, SWT.NONE);
        comboMetadir.add("meta/sql");
        comboMetadir.select(0);
    }

    /**
     * This method initializes comboSchema
     * 
     */
    private void createComboSchema() {
        comboSchema = new Combo(top, SWT.NONE);
    }
}