/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Iterator;

import blanco.db.definition.QueryCaller;
import blanco.db.expander.query.Finalize;
import blanco.db.expander.query.GetQueryMethod;
import blanco.db.expander.query.QueryConstructor;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;

/**
 * @author Yasuo Nakanishi
 */
public class QueryCallerClass extends ClassExpander {
    private BlancoDbObjectStorage storage = null;

    private QueryCaller _caller = null;

    public QueryCallerClass(final BlancoDbObjectStorage storage,
            final Type type, final QueryCaller caller) {
        super(type);
        _caller = caller;
        this.storage = storage;

        getJavaDoc().addLine(type.getName() + "NX<br>");
        getJavaDoc().addLine("QueryCallerɑNXłB<br>");
        getJavaDoc().addLine("ďo^SQLbsOĊeANZT񋟂܂B<br>");
    }

    protected void expandClassStruct() {
        addField(new FieldExpander(Connection.class, "fConnection"));
        addField(new FieldExpander(CallableStatement.class, "fStatement"));

        if (storage.getSetting().isLogging()) {
            addImport(new Type("org.apache.commons.logging.LogFactory"));
            final FieldExpander field1 = new FieldExpander(new Type(
                    "org.apache.commons.logging.Log"), "fLog") {
                protected boolean isStatic() {
                    return true;
                }

                protected boolean isFinal() {
                    return true;
                }
            };
            field1.getJavaDoc().addLine("MÔ߂̃IuWFNg<br>");
            field1.getJavaDoc().addLine("static final̏Ԃňێ܂");
            field1.setDefaultStatement(new Statement("LogFactory.getLog("
                    + getName() + ".class)"));
            addField(field1);
        }

        addMethod(new QueryConstructor(getType()));

        addMethod(new GetQueryMethod(_caller.getQuery()));

        addMethod(new PrepareCallMethod(storage));
        addMethod(new PrepareCallMethod2(storage, _caller));

        addMethod(new SetCallerInputParameterMethod(storage, _caller));

        addMethod(new ExecuteMethod(storage));

        final Iterator ite = _caller.getOutParameterIterator();
        while (ite.hasNext()) {
            final Value val = (Value) ite.next();
            addMethod(new GetCallerOutputParameterMethod(storage, _caller, val));
        }

        addMethod(new CloseMethod(storage));

        addMethod(new Finalize(storage, getName()));
    }
}