/*
 * blancoCommons Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * t@CXg[ւ̓o̓bp[<br>
 * java.io.Filejava.io.XXPutStreamn̓o͂ւƕϊs܂B
 * 
 * @author IGA Tosiki
 */
public abstract class File2StreamWrapper {
    private InputStream inStream = null;

    private OutputStream outStream = null;

    /**
     * java.io.Fileŗ^ꂽo͂Xg[x[Xɕϊ܂B<br>
     * ЕXg[ꍇɂ́Aʂ̌oHɂĎsӏɗ^ĂB
     * 
     * @param fileInput
     * @param fileOutput
     * @throws Exception
     */
    public File2StreamWrapper(final File fileInput, final File fileOutput)
            throws Exception {
        if (fileInput != null) {
            inStream = new BufferedInputStream(new FileInputStream(fileInput));
        }
        if (fileOutput != null) {
            outStream = new BufferedOutputStream(new FileOutputStream(
                    fileOutput));
        }
    }

    /**
     * o͏Ăяo܂
     * 
     * @param inStream
     * @param outStream
     * @throws Exception
     */
    public void run() throws Exception {
        try {
            process(inStream, outStream);

            // ɏIꍇɂflushĂяoĕ݂ۗ̏s܂B
            if (outStream != null) {
                outStream.flush();
            }
        } finally {
            // close͒ʂ悤ɂ܂B
            closeStream();
        }
    }

    /**
     * ۂ̓o͏ɋLڂ܂B
     * 
     * @param inStream
     * @param outStream
     * @throws Exception
     */
    protected abstract void process(final InputStream inStream,
            final OutputStream outStream) throws Exception;

    /**
     * Xg[N[Y܂B̃\bh̓RXgN^玩IɌĂяo܂B
     * 
     * @throws IOException
     */
    protected void closeStream() throws IOException {
        try {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
        } finally {
            if (outStream != null) {
                outStream.close();
                outStream = null;
            }
        }
    }
}
