/*
 * blancoCommons Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.commons.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BlancoXmlUtil {
    /**
     * IꂽGg當擾܂B
     * 
     * @param elementTarget
     * @return
     */
    public static final String getTextContent(final Element elementTarget) {
        String result = null;
        NodeList listText = elementTarget.getChildNodes();
        int sizeChildList = listText.getLength();
        for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
            Node nodeChild = listText.item(indexChild);
            if (nodeChild instanceof Text) {
                Text textLook = (Text) nodeChild;
                result = (result == null ? textLook.getData() : result
                        + textLook.getData());
            }
        }
        return result;
    }

    /**
     * Ggw̃^O̕ǂݍ݂܂B
     * 
     * @param elementTarget
     * @param tagName
     * @return
     */
    public static final String getTextContent(final Element elementTarget,
            final String tagName) {
        String result = null;
        NodeList listElementTarget = elementTarget
                .getElementsByTagName(tagName);
        int sizeList = listElementTarget.getLength();
        for (int index = 0; index < sizeList; index++) {
            Node nodeLook = listElementTarget.item(index);
            if (nodeLook instanceof Element) {
                Element elementLook = (Element) nodeLook;

                NodeList listText = elementLook.getChildNodes();
                int sizeChildList = listText.getLength();
                for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
                    Node nodeChild = listText.item(indexChild);
                    if (nodeChild instanceof Text) {
                        Text textLook = (Text) nodeChild;
                        result = (result == null ? textLook.getData() : result
                                + textLook.getData());
                    }
                }
            }
        }
        return result;
    }

    /**
     * ^ꂽXMLt@CDOMc[ɕϊ܂B
     * 
     * Iɂ́AʓIɗpXMLϊAPIpĕϊs܂B
     * 
     * @param metaXmlSourceFile
     *            XMLt@C
     * @return oDOMc[
     * @throws IllegalArgumentException
     *             ̓t@CsłꍇBXMLϊ擾ɎsꍇȂǁB
     */
    public static final DOMResult transformFile2Dom(final File metaXmlSourceFile) {
        if (metaXmlSourceFile.exists() == false) {
            throw new IllegalArgumentException("XMLt@CDOMւ̕ϊ: w肳ꂽt@C["
                    + metaXmlSourceFile.getAbsolutePath() + "]܂łB");
        }
        if (metaXmlSourceFile.isFile() == false) {
            throw new IllegalArgumentException("XMLt@CDOMւ̕ϊ: w肳ꂽt@C["
                    + metaXmlSourceFile.getAbsolutePath()
                    + "]ۂɂ̓t@Cł͂܂łB");
        }
        if (metaXmlSourceFile.canRead() == false) {
            throw new IllegalArgumentException("XMLt@CDOMւ̕ϊ: w肳ꂽt@C["
                    + metaXmlSourceFile.getAbsolutePath() + "]ǂݍݕs\łB");
        }

        InputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(
                    metaXmlSourceFile));
            return transformStream2Dom(inStream);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "z肵ȂO: XMLϊɃt@CȂO܂B" + e.toString());
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException(
                            "z肵ȂO: XMLϊ̍Ō̃t@CN[YɁAo͗O܂B"
                                    + e.toString());
                }
            }
        }
    }

    /**
     * ^ꂽXMLXg[DOMc[ɕϊ܂B
     * 
     * Iɂ́AʓIɗpXMLϊAPIpĕϊs܂B
     * 
     * @param inXmlSource
     *            XMLXg[
     * @return oDOMc[
     * @throws IllegalArgumentException
     *             ̓t@CsłꍇBXMLϊ擾ɎsꍇȂǁB
     */
    public static final DOMResult transformStream2Dom(
            final InputStream inXmlSource) {
        if (inXmlSource == null) {
            throw new IllegalArgumentException(
                    "XMLXg[DOMc[ɕϊ鏈ɁAXg[Ƃnulln܂BXg[ɂnullȊO^ĂB");
        }

        try {
            final DOMResult result = new DOMResult();
            final TransformerFactory tf = TransformerFactory.newInstance();
            final Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inXmlSource), result);
            return result;
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "z肵ȂO: XMLϊRtBO[VO܂B" + e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException("z肵ȂO: XMLϊO܂B"
                    + e.toString());
        }
    }
}
