/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.db.util.BlancoDbQueryParserUtil;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class GetQueryMethod extends MethodExpander {
    private String _query = "";

    public GetQueryMethod(final String query) {
        super("getQuery");
        _query = query;
    }

    public void setupSignature() {
        // getQuerypublicɕύXB
        setReturnType(new Type(String.class));

        getJavaDoc().addLine("NG̎擾\bh<br>");
        getJavaDoc().addLine("ۂɎsSQL߂܂B");
        getJavaDoc().addReturn("ۂɎsSQL");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        // 2005.04.15 t.iga s͉sƂďo͂悤ɕύXB
        // 2005.10.12 t.iga blancoCommons̕ϊ[eBeB𗘗p悤ɕύXB
        final String escapedQuery = BlancoJavaSourceUtil
                .escapeStringAsJavaSource(_query);

        // TODO: NG #p[^?ւ̕ϊ͓K؂ɏׂłB݂͉ŋo[W𗘗pB
        final String actualSql = new BlancoDbQueryParserUtil(escapedQuery)
                .getNaturalSqlString();

        implementor.addReturn(new StringLiteral(actualSql));
    }
}