/*
 * blancoDb
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import java.sql.SQLException;

import blanco.db.definition.QueryInvoker;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ExecuteUpdateMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    public ExecuteUpdateMethod(final BlancoDbObjectStorage storage,
            final QueryInvoker invoker) {
        super("executeUpdate");
        this.storage = storage;
    }

    public void setupSignature() {
        final Type resultType = new Type(int.class);
        setReturnType(resultType);

        final Type integrityConstraintException = new Type(storage.getSetting()
                .getRootNameSpace()
                + ".exception.IntegrityConstraintException");
        addException(integrityConstraintException);
        addUsingType(integrityConstraintException);

        addException(SQLException.class);

        getJavaDoc().addLine("s^NGs܂B<br>");
        getJavaDoc()
                .addLine(
                        "f[^x[X̐ᔽꍇɂ IntegrityConstraintException O܂B<br>");
        getJavaDoc().addReturn("ꂽs");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // statementmۂł΂AIprepareStatementĂяo܂B
        implementor.addLine("if (fStatement == null) {");
        implementor.addStatement("prepareStatement()");
        implementor.addLine("}");

        implementor.emptyLine();

        // ׂƓWJ܂B
        implementor.addLine("try {");
        implementor.addLine("return fStatement.executeUpdate();");
        implementor.addLine("} catch (SQLException ex) {");
        implementor
                .addLine("if (ex.getSQLState() != null && ex.getSQLState().startsWith(\"23\")) {");
        implementor
                .addLine("final IntegrityConstraintException exBlanco = new IntegrityConstraintException(\"ᔽɂύXɎs܂B:\" + ex.toString(), ex.getSQLState(), ex.getErrorCode());");
        implementor.addLine("exBlanco.initCause(ex);");
        implementor.addLine("throw exBlanco;");
        implementor.addLine("}");
        implementor.addLine("throw ex;");
        implementor.addLine("}");
    }
}