/*
 * blancoDb
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.SQLException;

import blanco.db.definition.QueryIterator;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * J[\truȅꍇɁÃ\bh͍쐬܂B
 * 
 * @author Tosiki Iga
 */
public class AbsoluteMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    public AbsoluteMethod(final BlancoDbObjectStorage storage,
            final QueryIterator iterator) {
        super("absolute");
        this.storage = storage;
    }

    public void setupSignature() {
        setReturnType(new Type(boolean.class));
        addException(SQLException.class);

        addArgument(new Value(int.class, "rows"));

        getJavaDoc().addLine("J[\ʃZbg̎w肳ꂽsֈړ܂B");
        getJavaDoc().addLine("absolute(1)first()ĂяôƓłB");
        getJavaDoc().addLine("absolute(-1)last()ĂяôƓłB");
        getJavaDoc().addReturn("V݂̍sLȏꍇtrueAȏ̍sȂꍇfalse");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName()
                    + ": rows = \" + rows);");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // resultSetmۂł΂AIexecuteQueryĂяo܂B
        implementor.addLine("if (fResultSet == null) {");
        implementor.addStatement("executeQuery()");
        implementor.addLine("}");

        implementor.addStatement("return fResultSet.absolute(rows)");
    }
}