/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.test.valueobject.BlancoValueObjectXml2JUnit;
import blanco.valueobject.BlancoValueObjectMeta2Xml;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;

public class BlancoValueObjectTask extends AbstractBlancoValueObjectTask {
    protected void process() throws IllegalArgumentException {
        try {
            File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            // e|fBNg쐬B
            new File(getTmpdir() + "/valueobject").mkdirs();

            // w肳ꂽ^fBNg𑖍B
            final File[] fileMeta = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta.length; index++) {
                if (fileMeta[index].getName().endsWith(".xls") == false) {
                    continue;
                }

                InputStream inStream = null;
                OutputStream outStream = null;
                try {
                    inStream = new BufferedInputStream(new FileInputStream(
                            fileMeta[index]));
                    outStream = new BufferedOutputStream(new FileOutputStream(
                            new File(getTmpdir() + "/valueobject/"
                                    + fileMeta[index].getName() + ".xml")));
                    new BlancoValueObjectMeta2Xml()
                            .process(inStream, outStream);
                    outStream.flush();
                } finally {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
            }

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File[] fileMeta2 = new File(getTmpdir() + "/valueobject")
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoValueObjectXml2JavaClass().process(fileMeta2[index],
                        new File(getTargetdir()));

                // P̎R[h
                if (getJunit().equals("true")) {
                    new BlancoValueObjectXml2JUnit().process(fileMeta2[index],
                            new File(getTargetdir()));
                }
            }

            // Ƀ^fBNg𑖍
            final File[] fileMeta3 = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta3.length; index++) {
                if (fileMeta3[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoValueObjectXml2JavaClass().process(fileMeta3[index],
                        new File(getTargetdir()));

                // P̎R[h
                if (getJunit().equals("true")) {
                    new BlancoValueObjectXml2JUnit().process(fileMeta2[index],
                            new File(getTargetdir()));
                }
            }
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        }
    }
}
