/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * \[XR[h̐ݒNXłB
 * 
 * @author Yasuo Nakanishi
 */
public class GeneratorSetting {

    private String _sourceEncoding = "";

    private String _workDirectory = "blanco";

    private String _mainOutputDirectory = "main";

    private String _testOutputDirectory = "test";

    private List _runtimeDirectoryList = new ArrayList();

    private String _rootNameSpace = "blanco";

    public GeneratorSetting() {
        _sourceEncoding = (String) System.getProperty("file.encoding");
    }

    public String getWorkDirectory() {
        return _workDirectory;
    }

    public void setWorkDirectory(String directory) {
        _workDirectory = directory;
    }

    public String getMainOutputDirectory() {
        return _workDirectory + "/" + _mainOutputDirectory;
    }

    public void setMainOutputDirectory(String directory) {
        _mainOutputDirectory = directory;
    }

    public String getSoruceEncoding() {
        return _sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        _sourceEncoding = sourceEncoding;
    }

    public String getTestOutputDirectory() {
        return _workDirectory + "/" + _testOutputDirectory;
    }

    public void setTestOutputDirectory(String testOutputDirectory) {
        _testOutputDirectory = testOutputDirectory;
    }

    public void addRuntimeDirectory(String path) {
        _runtimeDirectoryList.add(path);
    }

    public Iterator getRuntimeDirectoryIterator() {
        return _runtimeDirectoryList.iterator();
    }

    public String getRootNameSpace() {
        return _rootNameSpace;
    }

    public void setRootNameSpace(String rootNameSpace) {
        _rootNameSpace = rootNameSpace;
    }
}
