/*
 * blancoResourceBundle Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.resourcebundle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.commons.calc.parser.BlancoCalcParser;

/**
 * blancoResourceBundle <br>
 * ^񂩂vpeBt@C⃊\[XohANZTJava\[XR[h <br>
 * 
 * ^͂XMLo(XML֕ϊ)܂B <br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleMeta2Xml {

    public static void main(String[] args) {
        new File("tmp/resourcebundle").mkdirs();
        // System.out.println("^񂩂XMLt@C쐬: Jn");

        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(
                    "./meta/blancoResourceBundleTemplate.xls"));
            outStream = new BufferedOutputStream(new FileOutputStream(
                    "./tmp/resourcebundle/aaa1.xml"));
            new BlancoResourceBundleMeta2Xml().process(inStream, outStream);
            outStream.flush();
            inStream.close();
            inStream = null;
            outStream.close();
            outStream = null;

            inStream = new BufferedInputStream(new FileInputStream(
                    "./meta/program/blancoResourceBundleProgram.xls"));
            outStream = new BufferedOutputStream(new FileOutputStream(
                    "./tmp/resourcebundle/aaa.xml"));
            new BlancoResourceBundleMeta2Xml().process(inStream, outStream);
            outStream.flush();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (IOException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        // System.out.println("^񂩂XMLt@C쐬: I");
    }

    public void process(InputStream inStreamMetaSource,
            OutputStream outStreamTarget) throws TransformerException,
            IOException {
        InputStream inStreamDef = null;
        try {
            inStreamDef = new BufferedInputStream(
                    getClass()
                            .getClassLoader()
                            .getResourceAsStream(
                                    "blanco/resourcebundle/BlancoResourceBundleMeta2Xml.xml"));
            new BlancoCalcParser().process(inStreamDef, inStreamMetaSource,
                    outStreamTarget);
        } finally {
            if (inStreamDef != null)
                inStreamDef.close();
        }
    }
}