/*
 * blancoResourceBundle Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.resourcebundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import blanco.commons.util.BlancoXmlUtil;
import blanco.resourcebundle.expand.BlancoResourceBundleExpandResourceBundle;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * blancoResourceBundle <br>
 * ^񂩂vpeBt@C⃊\[XohANZTJava\[XR[h <br>
 * 
 * XML͂JavaNXE\[XR[h܂B <br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXml2JavaClass {
    private final BlancoResourceBundleResourceBundle bundle = new BlancoResourceBundleResourceBundle();

    public static void main(String[] args) {
        new BlancoResourceBundleXml2JavaClass().process(new File(
                "./tmp/resourcebundle/aaa1.combinedxml"), new File("blanco"));
        new BlancoResourceBundleXml2JavaClass().process(new File(
                "./tmp/resourcebundle/aaa.combinedxml"), new File("blanco"));
        // System.out.println("SĂ̏");
    }

    public void process(File fileSource, File directoryTarget) {
        DOMResult result = new DOMResult();
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(fileSource);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            Document rootDocument = (Document) rootNode;
            NodeList listSheet = rootDocument.getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            final HashMap mapProcessedBaseName = new HashMap(64);
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);
                // System.out.println("V[g[" + elementSheet.getAttribute("name")
                // + "]B");

                NodeList listCommon = elementSheet
                        .getElementsByTagName("blancoresourcebundle-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                Element elementCommon = (Element) listCommon.item(0);
                final String baseName = BlancoXmlUtil.getTextContent(
                        elementCommon, BlancoResourceBundleConstants.BASE_NAME);
                if (baseName == null) {
                    continue;
                }

                if (BlancoXmlUtil.getTextContent(elementCommon,
                        BlancoResourceBundleConstants.PACKAGE_NAME) == null) {
                    continue;
                }

                final ArrayList listLocale = new ArrayList();
                NodeList nodeListCommon = elementCommon
                        .getElementsByTagName(BlancoResourceBundleConstants.LOCALE);
                for (int indexLocale = 0; indexLocale < nodeListCommon
                        .getLength(); indexLocale++) {
                    Node nodeLook = nodeListCommon.item(indexLocale);
                    if (nodeLook instanceof Element) {
                        Element elementLook = (Element) nodeLook;
                        NodeList nodeChields = elementLook.getChildNodes();
                        for (int indexChild = 0; indexChild < nodeChields
                                .getLength(); indexChild++) {
                            Node nodeChild = nodeChields.item(indexChild);
                            if (nodeChild instanceof Text) {
                                listLocale.add(((Text) nodeChild)
                                        .getNodeValue());
                            }
                        }
                    }
                }
                if (listLocale.size() == 0) {
                    continue;
                }

                if (mapProcessedBaseName.get(baseName) != null) {
                    throw new IllegalArgumentException(
                            bundle
                                    .getXml2javaclassErr001(baseName,
                                            (String) mapProcessedBaseName
                                                    .get(baseName)));
                }
                expandSheet(elementSheet, elementCommon, directoryTarget);
                mapProcessedBaseName.put(baseName, "܂");
            }
        }
    }

    static void expandSheet(final Element elementSheet,
            final Element elementCommon, final File directoryTarget) {
        new BlancoResourceBundleExpandResourceBundle().expand(elementSheet,
                elementCommon, directoryTarget);
    }
}