/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.commons.calc.parser.BlancoCalcParser;

/**
 * ^񂩂璆ԃt@CłXML쐬܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectMeta2Xml {

    /**
     * Excelt@CXMLt@Cɕϊ܂B<br>
     * `t@C͓IɃpXێĂ܂B
     * 
     * @param inStreamMetaSource
     *            ^t@C̓̓Xg[
     * @param outStreamTarget
     *            o̓Xg[
     * @throws IOException
     *             o͗OꍇB
     * @throws TransformerException
     *             XMLϊOꍇB
     */
    public void process(InputStream inStreamMetaSource,
            OutputStream outStreamTarget) throws IOException,
            TransformerException {
        InputStream inStreamDef = null;
        try {
            inStreamDef = new BufferedInputStream(getClass().getClassLoader()
                    .getResourceAsStream(
                            "blanco/valueobject/BlancoValueObjectMeta2Xml.xml"));
            new BlancoCalcParser().process(inStreamDef, inStreamMetaSource,
                    outStreamTarget);
        } finally {
            if (inStreamDef != null)
                inStreamDef.close();
        }
    }
}