/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.sql.SQLException;

import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ExecuteMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    public ExecuteMethod(final BlancoDbObjectStorage storage) {
        super("execute");
        this.storage = storage;
    }

    public void setupSignature() {
        addException(SQLException.class);

        getJavaDoc().addLine("XgAhvV[Ws܂B<br>");
    }

    public void implement() {
        if (storage.getSetting().isLogging()) {
            getData().addLine("if (fLog.isDebugEnabled()) {");
            getData().addLine("fLog.debug(\"" + getName() + "\");");
            getData().addLine("}");
            getData().addLine("");
        }

        getData().addLine("if (fStatement == null) {");
        getData().addLine("prepareCall();");
        getData().addLine("}");
        getData().addLine("");

        getData().addLine("// execute\bh̎sʂɂĂ͈ȂƂƂ܂B");
        getData().addLine("fStatement.execute();");
    }
}