/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import java.sql.SQLException;

import blanco.db.definition.QueryInvoker;
import blanco.db.exception.NoRowModifiedException;
import blanco.db.exception.TooManyRowsModifiedException;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class ExecuteSingleUpdateMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    public ExecuteSingleUpdateMethod(final BlancoDbObjectStorage storage,
            final QueryInvoker invoker) {
        super("executeSingleUpdate");
        this.storage = storage;
    }

    public void setupSignature() {
        final Type resultType = new Type(void.class);

        setReturnType(resultType);

        final Type noRowModifiedException = new Type(storage.getSetting()
                .getRootNameSpace()
                + ".exception.NoRowModifiedException");
        addException(noRowModifiedException);
        addUsingType(noRowModifiedException);
        final Type tooManyRowsModifiedException = new Type(storage.getSetting()
                .getRootNameSpace()
                + ".exception.TooManyRowsModifiedException");
        addException(tooManyRowsModifiedException);
        addUsingType(tooManyRowsModifiedException);

        final Type integrityConstraintException = new Type(storage.getSetting()
                .getRootNameSpace()
                + ".exception.IntegrityConstraintException");
        addException(integrityConstraintException);
        addUsingType(integrityConstraintException);

        addException(SQLException.class);

        getJavaDoc().addLine("s^NGs܂B<br>");
        getJavaDoc()
                .addLine(
                        "f[^x[X̐ᔽꍇɂ IntegrityConstraintException O܂B<br>");

        getJavaDoc().addLine("");
        getJavaDoc().addLine("singleL<br>");
        getJavaDoc().addLine("sʂ1ȊȌꍇɂ́ANotSingleRowExceptionNX");
        getJavaDoc().addLine("hNX̗O܂B");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        final Value result = new Value(int.class, "result");
        getField("fStatement");

        implementor.declare(result, new Statement(int.class, "0"));

        implementor.addStatement("result = executeUpdate()");

        implementor.emptyLine();

        final Type noModified = storage
                .createRuntime(NoRowModifiedException.class);
        final Type tooMeny = storage
                .createRuntime(TooManyRowsModifiedException.class);

        Statement s = new Statement(result);
        s.join("==", new Statement(int.class, "0"));
        implementor.openIf(s);

        Call c = new Call(noModified);
        c.addArgument(new StringLiteral("sꌏύX܂łB"));
        implementor.addThrow(c);

        s = new Statement(result);
        s.join(">", new Statement(int.class, "1"));
        implementor.addElseIf(s);

        Value message = new Value(String.class, "message");
        s = new StringLiteral("ꌏ𒴂sύXĂ܂܂Bê:");
        s.join("+", new Statement(result));
        implementor.declare(message, s);

        c = new Call(tooMeny);
        c.addArgument(message);
        implementor.addThrow(c);

        implementor.closeIf();
    }
}