/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.sql.SQLException;

import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class PrepareStatementMethod extends MethodExpander {
    public PrepareStatementMethod(final BlancoDbObjectStorage storage) {
        super("prepareStatement");
    }

    public void setupSignature() {
        addException(SQLException.class);

        getJavaDoc().addLine("NG̃vRpC{܂B<br>");
        getJavaDoc().addLine("Iɂ Connection.prepareStatement Ăяo܂B");
        getJavaDoc().addLine("炩ߗ^ĂNG(SQL)𗘗p܂B");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());
        implementor.addStatement("close()");
        implementor.addStatement("prepareStatement(getQuery())");
    }
}