/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sax;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

import javax.xml.transform.sax.SAXResult;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.Constructor;
import blanco.ig.expander.method.MethodExpander;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;
import blanco.sax.util.BlancoSaxUtil;

/**
 * ͗pXML͂ċۉSAXC^[𐶐܂B<br>
 * ̃NXł́AConcreteSaxSerializer𐶐܂B<br>
 * <br>
 * ͂͗pXMLt@ĆAӓIȂ̂܂B_ł ȂIȂ̂ɂȂ܂B<br>
 * 1: ͗pXML̃Agr[gׂ͂Ďw肳ė̂Ɖ肵܂B<br>
 * 2: قȂKwɂēÕGeBeB݂Ȃ̂Ɖ肵܂B<br>
 * Ql:http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/org/xml/sax/ContentHandler.html<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoSaxXml2Serializer {
    /**
     * oꂵGgׂĂL܂B<br>
     * 2xڂɓoꂵGg𖳎邽߂ɂp܂B
     */
    private final Hashtable totalElementHashtable = new Hashtable();

    /**
     * eXgp̃Gg|Cg
     * 
     * @param args
     */
    public static void main(String[] args) {
        try {
            new BlancoSaxXml2Serializer().process(new File(
                    BlancoSaxXml2Handler.MAIN_INPUT_FILENAME), "blanco",
                    "blanco.plugin.soap.concretesax",
                    "BlancoSoapBlancoFwSerializer");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * \[XR[hs܂B
     * 
     * @param sourceFile
     * @param targetDirectory
     * @param packageName
     * @param className
     * @throws IOException
     */
    public void process(final File sourceFile, final String targetDirectory,
            final String packageName, final String className)
            throws IOException {
        // Java\[XR[h𐶐̂߂̐ݒ
        GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(targetDirectory);
        ImplementGenerator implementGenerator = new ImplementGenerator(setting);
        // 쐬NXo^܂B
        implementGenerator.addMain(getClassExpander(sourceFile, packageName,
                className));
        // ۂɃ\[XR[hs܂B
        implementGenerator.generate();
        // System.out.println("\[XR[h܂B");
    }

    /**
     * ̃NXWJs܂B
     * 
     * @param sourceFile
     * @param packageName
     * @param className
     * @return
     */
    private ClassExpander getClassExpander(final File sourceFile,
            final String packageName, final String className) {
        return new ClassExpander(new Type(packageName, className)) {
            protected void expandClassStruct() {
                addFileComment(className + "ۉSAXNX<br>");
                getJavaDoc().addLine(className + "ۉSAXNX<br>");
                getJavaDoc().addLine("SAX𗘗pXMLobsONXłB<br>");
                getJavaDoc().addLine(
                        "̃NX͉͗pXMLt@C͂ƂċۉSAXNXƂĐ܂B<br>");
                getJavaDoc().addLine("̃\[XR[hblancoIgɂ@BIɎĂ܂B");
                getJavaDoc().addLine(
                        "̃NX implements ContentHandler ͍s܂B<br>");
                getJavaDoc().addLine("T^Iȗp@͉L̂悤ɂȂ܂B<br>");
                getJavaDoc().addLine("<pre>");
                getJavaDoc().addLine(
                        className + " serializer = new " + className
                                + "(outStream);");
                getJavaDoc().addLine("serializer.startDocument();");
                getJavaDoc().addLine("serializer.startElementXXXX();");
                getJavaDoc().addLine("serializer.characters(\"\");");
                getJavaDoc().addLine("serializer.endElementXXXX();");
                getJavaDoc().addLine("serializer.endDocument();");
                getJavaDoc().addLine("</pre>");

                // tB[hϐ錾܂B
                FieldExpander field1 = new FieldExpander(new Type(
                        "javax.xml.transform.sax.TransformerHandler"),
                        "fSaxHandler") {
                };
                field1.getJavaDoc().addLine("Iɗpo͗pSAXnh<br>");
                field1.getJavaDoc().addLine("ÃXg[͊OcloseKv܂B");
                addField(field1);

                addMethod(new Constructor(className) {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        addUsingType(new Type(
                                "javax.xml.transform.TransformerConfigurationException"));
                        addUsingType(new Type(
                                "javax.xml.transform.TransformerFactory"));
                        addUsingType(new Type(
                                "javax.xml.transform.sax.SAXTransformerFactory"));
                        addUsingType(new Type(
                                "javax.xml.transform.sax.TransformerHandler"));
                        addUsingType(new Type(
                                "javax.xml.transform.stream.StreamResult"));
                        addArgument(new Value(new Type("java.io.OutputStream"),
                                "outStream"));
                        addException(new Type(
                                "javax.xml.transform.TransformerConfigurationException"));
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "TransformerFactory tf = TransformerFactory.newInstance();");
                        getData()
                                .addLine(
                                        "SAXTransformerFactory saxTf = (SAXTransformerFactory) tf;");
                        getData().addLine(
                                "fSaxHandler = saxTf.newTransformerHandler();");
                        getData()
                                .addLine(
                                        "fSaxHandler.setResult(new StreamResult(outStream));");
                    }
                });

                addMethod(new Constructor(className) {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        addUsingType(new Type(
                                "javax.xml.transform.TransformerConfigurationException"));
                        addUsingType(new Type(
                                "javax.xml.transform.TransformerFactory"));
                        addUsingType(new Type(
                                "javax.xml.transform.sax.SAXTransformerFactory"));
                        addUsingType(new Type(
                                "javax.xml.transform.sax.TransformerHandler"));
                        addUsingType(new Type(
                                "javax.xml.transform.stream.StreamResult"));
                        addArgument(new Value(new Type("java.io.Writer"),
                                "writer"));
                        addException(new Type(
                                "javax.xml.transform.TransformerConfigurationException"));
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "TransformerFactory tf = TransformerFactory.newInstance();");
                        getData()
                                .addLine(
                                        "SAXTransformerFactory saxTf = (SAXTransformerFactory) tf;");
                        getData().addLine(
                                "fSaxHandler = saxTf.newTransformerHandler();");
                        getData()
                                .addLine(
                                        "fSaxHandler.setResult(new StreamResult(writer));");
                    }
                });

                addMethod(new MethodExpander("getTransformerHandler") {
                    public void setupSignature() {
                        getJavaDoc().addLine("TransformerHandler擾܂<br>");
                        getJavaDoc()
                                .addLine(
                                        "ꂽʏ̃nhŏłȂȂǂ́Aނ𓾂Ȃꍇɂ̂݌ĂяoėpĂB");
                        setReturnType(new Type(
                                "javax.xml.transform.sax.TransformerHandler"));
                    }

                    public void implement() {
                        getData().addLine("return fSaxHandler;");
                    }
                });

                addMethod(new MethodExpander("startDocument") {
                    public void setupSignature() {
                        getJavaDoc().addLine("startDocument𔭐܂B");
                        getJavaDoc().addException(
                                new Type("org.xml.sax.SAXException"),
                                "SAX֘A̗OꍇB");
                        addException(new Type("org.xml.sax.SAXException"));
                    }

                    public void implement() {
                        getData().addLine("fSaxHandler.startDocument();");
                    }
                });

                addMethod(new MethodExpander("endDocument") {
                    public void setupSignature() {
                        getJavaDoc().addLine("endDocument𔭐܂B");
                        getJavaDoc().addException(
                                new Type("org.xml.sax.SAXException"),
                                "SAX֘A̗OꍇB");
                        addException(new Type("org.xml.sax.SAXException"));
                    }

                    public void implement() {
                        getData().addLine("fSaxHandler.endDocument();");
                    }
                });

                addMethod(new MethodExpander("startPrefixMapping") {
                    public void setupSignature() {
                        addException(new Type("org.xml.sax.SAXException"));
                        getJavaDoc().addLine("startPrefixMapping𔭐܂B");
                        addArgument(new Value(new Type("java.lang.String"),
                                "prefix"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "uri"));
                    }

                    public void implement() {
                        getData().addLine(
                                "fSaxHandler.startPrefixMapping(prefix, uri);");
                    }
                });

                addMethod(new MethodExpander("endPrefixMapping") {
                    public void setupSignature() {
                        getJavaDoc().addLine("endPrefixMapping𔭐܂B");
                        getJavaDoc().addException(
                                new Type("org.xml.sax.SAXException"),
                                "SAX֘A̗OꍇB");
                        addException(new Type("org.xml.sax.SAXException"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "prefix"));
                    }

                    public void implement() {
                        getData().addLine(
                                "fSaxHandler.endPrefixMapping(prefix);");
                    }
                });

                addMethod(new MethodExpander("setDocumentLocator") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine("setDocumentLocator𔭐܂BB");
                        getJavaDoc().addParameter("locator", "P[^");
                        addArgument(new Value(new Type("org.xml.sax.Locator"),
                                "locator"));
                    }

                    public void implement() {
                        getData().addLine(
                                "fSaxHandler.setDocumentLocator(locator);");
                    }
                });

                addMethod(new MethodExpander("processingInstruction") {
                    public void setupSignature() {
                        getJavaDoc().addLine("processingInstruction𔭐܂B");
                        getJavaDoc().addException(
                                new Type("org.xml.sax.SAXException"),
                                "SAX֘A̗OꍇB");
                        addException(new Type("org.xml.sax.SAXException"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "target"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "data"));
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "fSaxHandler.processingInstruction(target, data);");
                    }
                });

                addMethod(new MethodExpander("skippedEntity") {
                    public void setupSignature() {
                        getJavaDoc().addLine("skippedEntity𔭐܂B");
                        getJavaDoc().addException(
                                new Type("org.xml.sax.SAXException"),
                                "SAX֘A̗OꍇB");
                        addException(new Type("org.xml.sax.SAXException"));
                        addArgument(new Value(new Type("java.lang.String"),
                                "name"));
                    }

                    public void implement() {
                        getData().addLine("fSaxHandler.skippedEntity(name);");
                    }
                });

                addMethod(new MethodExpander("characters") {
                    public void setupSignature() {
                        getJavaDoc().addLine("characters\bhĂяo܂B<br>");
                        getJavaDoc().addException(
                                new Type("org.xml.sax.SAXException"),
                                "SAX֘A̗OꍇB");
                        addException(new Type("org.xml.sax.SAXException"));
                        getJavaDoc().addParameter("ch", "o͂");
                        getJavaDoc().addParameter("start", "Jnʒu");
                        getJavaDoc().addParameter("length", "̒");
                        addException(new Type("org.xml.sax.SAXException"));
                        addArgument(new Value(new Type("char[]"), "ch"));
                        addArgument(new Value(new Type("int"), "start"));
                        addArgument(new Value(new Type("int"), "length"));
                    }

                    public void implement() {
                        getData().addLine(
                                "fSaxHandler.characters(ch, start, length);");
                    }
                });

                addMethod(new MethodExpander("characters") {
                    public void setupSignature() {
                        getJavaDoc().addLine("characters\bhĂяo܂B<br>");
                        getJavaDoc().addLine(
                                "ȈՉ̂߂  java.lang.StrinĝłB");
                        getJavaDoc().addException(
                                new Type("org.xml.sax.SAXException"),
                                "SAX֘A̗OꍇB");
                        addException(new Type("org.xml.sax.SAXException"));
                        getJavaDoc().addParameter("data", "o͂");
                        addArgument(new Value(new Type("String"), "data"));
                    }

                    public void implement() {
                        getData().addLine(
                                "final char[] chars = data.toCharArray();");
                        getData()
                                .addLine(
                                        "fSaxHandler.characters(chars, 0, chars.length);");
                    }
                });

                addMethod(new MethodExpander("ignorableWhitespace") {
                    public void setupSignature() {
                        getJavaDoc().addLine("ignorableWhitespace𔭐܂B");
                        getJavaDoc().addException(
                                new Type("org.xml.sax.SAXException"),
                                "SAX֘A̗OꍇB");
                        addException(new Type("org.xml.sax.SAXException"));
                        addArgument(new Value(new Type("char[]"), "ch"));
                        addArgument(new Value(new Type("int"), "start"));
                        addArgument(new Value(new Type("int"), "length"));
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "fSaxHandler.ignorableWhitespace(ch, start, length);");
                    }
                });

                SAXResult result = new SAXResult(new ContentHandler() {
                    public void setDocumentLocator(Locator arg0) {
                    }

                    public void startDocument() throws SAXException {
                    }

                    public void endDocument() throws SAXException {
                    }

                    //  startElement̏s܂B

                    /**
                     * startElementĂяoꂽۂɁAʂ̃\bh̍쐬s܂B
                     */
                    public void startElement(final String uri,
                            final String localName, final String qName,
                            final Attributes atts) throws SAXException {
                        if (totalElementHashtable.get(qName) != null) {
                            // łɓoꂵGgłB
                            // ̓XLbv܂B
                            return;
                        }

                        final AttributesImpl attrImplCopy = new AttributesImpl();

                        for (int index = 0; index < atts.getLength(); index++) {
                            attrImplCopy.addAttribute(atts.getURI(index), atts
                                    .getLocalName(index), atts.getQName(index),
                                    atts.getType(index), atts.getValue(index));
                        }

                        totalElementHashtable.put(qName, "łɓo");

                        addMethod(new MethodExpander("startElement"
                                + BlancoNameAdjuster.toClassName(qName)) {
                            // \bh̃VOj`w

                            public void setupSignature() {
                                getJavaDoc().addLine(
                                        "startElementړt̏C[" + qName
                                                + "]ƂČĂяo܂B<br>");
                                getJavaDoc()
                                        .addLine(
                                                "{Iȏ̓\bhɊ܂܂̂ň͏Ă܂B<br>");
                                getJavaDoc().addLine(
                                        "OURI     [" + uri + "]<br>");
                                getJavaDoc().addLine(
                                        "[J       [" + localName + "]<br>");
                                getJavaDoc().addLine(
                                        "ړt̏C[" + qName + "]<br>");
                                addException(new Type(
                                        "org.xml.sax.SAXException"));

                                for (int index = 0; index < attrImplCopy
                                        .getLength(); index++) {
                                    getJavaDoc()
                                            .addParameter(
                                                    "attr"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(attrImplCopy
                                                                            .getQName(index)),
                                                    "Agr[g["
                                                            + attrImplCopy
                                                                    .getQName(index)
                                                            + "]̒ln܂BAgr[gZbgȂꍇɂ nullZbgĂB");
                                    addArgument(new Value(new Type(
                                            "java.lang.String"), "attr"
                                            + BlancoNameAdjuster
                                                    .toClassName(attrImplCopy
                                                            .getQName(index))));
                                }
                            }

                            public void implement() {
                                addUsingType(new Type(
                                        "org.xml.sax.helpers.AttributesImpl;"));
                                getData()
                                        .addLine(
                                                "AttributesImpl attributes = new AttributesImpl();");

                                for (int index = 0; index < attrImplCopy
                                        .getLength(); index++) {
                                    getData()
                                            .addLine(
                                                    "if (attr"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(attrImplCopy
                                                                            .getQName(index))
                                                            + " != null) {");
                                    getData()
                                            .addLine(
                                                    "attributes.addAttribute(\""
                                                            + (BlancoSaxXml2Handler
                                                                    .isXmlNaturePrefix(attrImplCopy
                                                                            .getURI(index)) ? ""
                                                                    : attrImplCopy
                                                                            .getURI(index))
                                                            + "\", \""
                                                            + attrImplCopy
                                                                    .getLocalName(index)
                                                            + "\", \""
                                                            + attrImplCopy
                                                                    .getQName(index)
                                                            + "\", \""
                                                            + attrImplCopy
                                                                    .getType(index)
                                                            + "\", attr"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(attrImplCopy
                                                                            .getQName(index))
                                                            + ");");
                                    getData().addLine("}");
                                }

                                getData().addLine(
                                        "fSaxHandler.startElement(\"" + uri
                                                + "\", \"" + localName
                                                + "\", \"" + qName
                                                + "\", attributes);");
                            }
                        });

                        addMethod(new MethodExpander("endElement"
                                + BlancoNameAdjuster.toClassName(qName)) {

                            // \bh̃VOj`w
                            public void setupSignature() {
                                getJavaDoc().addLine(
                                        "endElementړt̏C[" + qName
                                                + "]ƂČĂяo܂B<br>");
                                getJavaDoc()
                                        .addLine(
                                                "{Iȏ̓\bhɊ܂܂̂ň͏Ă܂B<br>");
                                getJavaDoc().addLine(
                                        "OURI     [" + uri + "]<br>");
                                getJavaDoc().addLine(
                                        "[J       [" + localName + "]<br>");
                                getJavaDoc().addLine(
                                        "ړt̏C[" + qName + "]<br>");
                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                            }

                            public void implement() {
                                getData().addLine(
                                        "fSaxHandler.endElement(\"" + uri
                                                + "\", \"" + localName
                                                + "\", \"" + qName + "\");");
                            }
                        });
                    }

                    // ܂ł startElement̏łB

                    public void endElement(String uri, String localName,
                            String qName) throws SAXException {
                    }

                    public void startPrefixMapping(String arg0, String arg1)
                            throws SAXException {
                    }

                    public void endPrefixMapping(String arg0)
                            throws SAXException {
                    }

                    public void characters(char[] ch, int start, int length)
                            throws SAXException {
                    }

                    public void ignorableWhitespace(char[] arg0, int arg1,
                            int arg2) throws SAXException {
                    }

                    public void processingInstruction(String arg0, String arg1)
                            throws SAXException {
                    }

                    public void skippedEntity(String arg0) throws SAXException {
                    }
                });

                BlancoSaxUtil.doTransform(sourceFile, result);
            }
        };
    }
}
