/*
 * blancoCommons Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.calc.parser.block;

import java.util.ArrayList;

/**
 * L[}bṽubN܂B
 * 
 * @author iga
 */
public class BlancoCalcParserPropertyBlock extends
        AbstractBlancoCalcParserBlock {

    private ArrayList list = new ArrayList();

    public BlancoCalcParserPropertyBlock(String name) {
        setName(name);
    }

    public void add(BlancoCalcParserPropertyKey item) {
        list.add(item);
    }

    /**
     * JnɗACe܂B
     * 
     * @param startString
     * @return
     */
    public BlancoCalcParserPropertyKey findByStartString(String startString) {
        for (int index = 0; index < list.size(); index++) {
            BlancoCalcParserPropertyKey item = (BlancoCalcParserPropertyKey) list
                    .get(index);
            if (item.isStartString(startString)) {
                return item;
            }
        }
        return null;
    }
}
