/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.field;

import java.util.ArrayList;
import java.util.List;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Expander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.javadoc.MethodJavaDoc;

/**
 * @author Yasuo Nakanishi
 */
public class FieldExpander extends Expander {
    private Value _value = null;

    private Value _fieldValue = null;

    private MethodJavaDoc _javaDoc = new MethodJavaDoc();

    private String _defaultValue = "";

    private List _usingType = new ArrayList();

    /**
     * tB[h̓ftHgPRIVATEƂ܂B
     */
    protected Scope getScope() {
        return Scope.PRIVATE;
    }

    public FieldExpander(Class type, String name) {
        this(new Value(type, name));
    }

    public FieldExpander(Type type, String name) {
        this(new Value(type, name));
    }

    public FieldExpander(Value value) {
        this(value, value.getName());
    }

    public FieldExpander(Value value, String fieldName) {
        _value = value;
        _fieldValue = new Value(_value.getType(), fieldName);
        _usingType.add(_value.getType());
    }

    public Value getFieldValue() {
        return _fieldValue;
    }

    public MethodJavaDoc getJavaDoc() {
        return _javaDoc;
    }

    public void setLiteralValue(String literal) {
        StringBuffer sb = new StringBuffer(literal);
        if (_value.getType().equals(String.class)) {
            sb.insert(0, "\"");
            sb.append("\"");
        }
        _defaultValue = sb.toString();
    }

    public void setDefaultValue(Class constructType) {
        _defaultValue = "new" + constructType.getName() + "()";
        _usingType.add(new Type(constructType));
    }

    public void setDefaultStatement(Statement statement) {
        _defaultValue = statement.toString();
        _usingType.addAll(statement.getUsingTypeList());
    }

    public Value getTypeValue() {
        return _value;
    }

    public String getFieldDeclaration() {
        final StringBuffer sb = new StringBuffer();
        // ƂăL[[ȟɋ󔒂t^܂B
        sb.append(getScope().get());
        sb.append(" ");

        if (isStatic()) {
            sb.append("static ");
        }

        if (isFinal()) {
            sb.append("final ");
        }

        sb.append(_value.getType().getName());
        sb.append(" ");
        sb.append(_fieldValue.getName());

        if (!_defaultValue.equals("")) {
            sb.append(" = ");
            sb.append(_defaultValue);
        }
        sb.append(";");
        return new String(sb);
    }

    public List expand() {
        List result = new ArrayList();
        if (!_javaDoc.isEmpty()) {
            List list = _javaDoc.expand();
            for (int i = 0; i < list.size(); i++) {
                result.add(ClassExpander.INDENT + list.get(i));
            }
        }
        if (getAnnotationList().isEmpty() == false) {
            // tB[h̃Ame[VWJ܂B
            for (int index = 0; index < getAnnotationList().size(); index++) {
                result.add(ClassExpander.INDENT + "@"
                        + (String) getAnnotationList().get(index));
            }
        }
        result.add(ClassExpander.INDENT + getFieldDeclaration());
        return result;
    }

    public List getUsingTypeList() {
        return _usingType;
    }
}
