package blanco.test.db.test;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;

import junit.framework.TestCase;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary10DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary10InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary10SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary11DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary11InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary11SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary13DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary13InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary13SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary14DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary14InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary14SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary15DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary15InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary15SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary16DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary16InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary16SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary17DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary17InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary17SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary18DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary18InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary18SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary1DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary1InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary1SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary20InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary21DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary21InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary21SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary22DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary22InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary22SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary23DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary23InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary23SelectAllIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary24DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary24InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary24SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary24SelectUpdatableIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary2DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary2InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary2SelectAllIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary3DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary3InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary3SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary4DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary4InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary4SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary5DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary5InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary5SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary6DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary6InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary6SelectIterator;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary7DeleteInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary7InsertInvoker;
import test.sqlserver2005.query.SimpleTestSingleColumnPrimary7SelectIterator;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary10SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary11SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary13SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary14SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary15SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary16SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary17SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary18SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary1SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary21SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary22SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary23SelectAllRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary24SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary24SelectUpdatableRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary2SelectAllRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary3SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary4SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary5SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary6SelectRow;
import test.sqlserver2005.row.SimpleTestSingleColumnPrimary7SelectRow;
import blanco.commons.util.BlancoStreamUtil;

public class SimpleTableSQLServer2005Test extends TestCase {
    /**
     * ̎̒ŗpf[^x[XRlNVB
     */
    private Connection fConn = null;

    /**
     * A̎̂߂̏s܂B
     */
    protected void setUp() throws Exception {
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        fConn = DriverManager.getConnection("jdbc:sqlserver://localhost",
                "blancodb", "blancodb");
        fConn.setAutoCommit(false);
    }

    /**
     * A̎̂߂̏Is܂B
     */
    protected void tearDown() throws Exception {
        if (fConn != null) {
            try {
                fConn.rollback();
            } finally {
                fConn.close();
                fConn = null;
            }
        }
    }

    /**
     * long: nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary1() throws Exception {
        final long primaryKey = 1234567890123456789L;
        final SimpleTestSingleColumnPrimary1InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary1InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary1SelectIterator iterator = new SimpleTestSingleColumnPrimary1SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary1SelectRow row = iterator
                    .getSingleRow();
            assertEquals(primaryKey, row.getFieldBigint());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary1DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary1DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * oCi^
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary2() throws Exception {
        final byte[] primaryKey = "ABCDE".getBytes();
        final SimpleTestSingleColumnPrimary2InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary2InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(
                    new ByteArrayInputStream(primaryKey), primaryKey.length);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary2SelectAllIterator iterator = new SimpleTestSingleColumnPrimary2SelectAllIterator(
                fConn);
        try {
            assertTrue(iterator.next());
            final SimpleTestSingleColumnPrimary2SelectAllRow row = iterator
                    .getRow();
            // BINARY^̓TCY܂^Ȃ̂ŁAɎŋl܂܂B
            assertEquals(new String(primaryKey), new String(BlancoStreamUtil
                    .stream2Bytes(row.getFieldBinary()), 0, 5));
            assertFalse(iterator.next());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary2DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary2DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(new ByteArrayInputStream(
                    (primaryKey)), primaryKey.length);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    public void testSimpleTestSingleColumnPrimary3() throws Exception {
        final boolean primaryKey = false;
        final SimpleTestSingleColumnPrimary3InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary3InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary3SelectIterator iterator = new SimpleTestSingleColumnPrimary3SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary3SelectRow row = iterator
                    .getSingleRow();
            assertEquals(primaryKey, row.getFieldBit());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary3DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary3DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    public void testSimpleTestSingleColumnPrimary4() throws Exception {
        final String primaryKey = "ABC";
        final SimpleTestSingleColumnPrimary4InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary4InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary4SelectIterator iterator = new SimpleTestSingleColumnPrimary4SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary4SelectRow row = iterator
                    .getSingleRow();
            // ɋ󔒕t^܂B
            assertEquals(primaryKey + "       ", row.getFieldChar());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary4DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary4DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * Date: tnB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary5() throws Exception {
        final Date primaryKey = new Date();
        final SimpleTestSingleColumnPrimary5InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary5InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary5SelectIterator iterator = new SimpleTestSingleColumnPrimary5SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary5SelectRow row = iterator
                    .getSingleRow();
            // RDBɊi[ĎoƐx܂B
            assertEquals(primaryKey.toString(), row.getFieldDatetime()
                    .toString());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary5DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary5DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    public void testSimpleTestSingleColumnPrimary6() throws Exception {
        final BigDecimal primaryKey = new BigDecimal("1234567890.123");
        final SimpleTestSingleColumnPrimary6InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary6InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary6SelectIterator iterator = new SimpleTestSingleColumnPrimary6SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary6SelectRow row = iterator
                    .getSingleRow();
            // fV}^ƂĂ̔rs܂B
            assertTrue(primaryKey.compareTo(row.getFieldDecimal()) == 0);
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary6DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary6DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * double: _nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary7() throws Exception {
        final double primaryKey = 1234.5678;
        final SimpleTestSingleColumnPrimary7InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary7InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary7SelectIterator iterator = new SimpleTestSingleColumnPrimary7SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary7SelectRow row = iterator
                    .getSingleRow();
            assertEquals("doublel̈vmFB", primaryKey, row.getFieldFloat(), 0);
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary7DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary7DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * MONEY: fV}nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary10() throws Exception {
        final BigDecimal primaryKey = new BigDecimal("1234567890.123");
        final SimpleTestSingleColumnPrimary10InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary10InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary10SelectIterator iterator = new SimpleTestSingleColumnPrimary10SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary10SelectRow row = iterator
                    .getSingleRow();
            // fV}^ƂĂ̔rs܂B
            assertTrue(primaryKey.compareTo(row.getFieldMoney()) == 0);
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary10DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary10DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * NCHAR: nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary11() throws Exception {
        final String primaryKey = "ABCDEFG";
        final SimpleTestSingleColumnPrimary11InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary11InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary11SelectIterator iterator = new SimpleTestSingleColumnPrimary11SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary11SelectRow row = iterator
                    .getSingleRow();
            // ɋ󔒕t^܂B
            assertEquals(primaryKey + "   ", row.getFieldNchar());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary11DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary11DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    public void testSimpleTestSingleColumnPrimary13() throws Exception {
        final BigDecimal primaryKey = new BigDecimal("1234567890");
        final SimpleTestSingleColumnPrimary13InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary13InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary13SelectIterator iterator = new SimpleTestSingleColumnPrimary13SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary13SelectRow row = iterator
                    .getSingleRow();
            // fV}^ƂĂ̔rs܂B
            assertTrue(primaryKey.compareTo(row.getFieldNumeric()) == 0);
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary13DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary13DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * NVARCHAR: nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary14() throws Exception {
        final String primaryKey = "ABCDEFG";
        final SimpleTestSingleColumnPrimary14InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary14InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary14SelectIterator iterator = new SimpleTestSingleColumnPrimary14SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary14SelectRow row = iterator
                    .getSingleRow();
            assertEquals(primaryKey, row.getFieldNvarchar());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary14DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary14DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * double: _nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary15() throws Exception {
        final float primaryKey = (float) 1234.5678;
        final SimpleTestSingleColumnPrimary15InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary15InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary15SelectIterator iterator = new SimpleTestSingleColumnPrimary15SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary15SelectRow row = iterator
                    .getSingleRow();
            // SQL Server 2005łREADfloatɃ}bv܂B
            assertEquals("floatl̈vmFB", primaryKey, row.getFieldReal(), 0);
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary15DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary15DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * Date: tnB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary16() throws Exception {
        final Calendar cal = Calendar.getInstance();
        // SMALLDATETIMEł͕bƃ~bۂ܂܂B
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        final Date primaryKey = cal.getTime();
        final SimpleTestSingleColumnPrimary16InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary16InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary16SelectIterator iterator = new SimpleTestSingleColumnPrimary16SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary16SelectRow row = iterator
                    .getSingleRow();
            // RDBɊi[ĎoƐx܂B
            assertEquals(primaryKey.toString(), row.getFieldSmalldatetime()
                    .toString());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary16DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary16DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * long: nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary17() throws Exception {
        final short primaryKey = (short) 12345678;
        final SimpleTestSingleColumnPrimary17InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary17InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary17SelectIterator iterator = new SimpleTestSingleColumnPrimary17SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary17SelectRow row = iterator
                    .getSingleRow();
            assertEquals(primaryKey, row.getFieldSmallint());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary17DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary17DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * MONEY: fV}nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary18() throws Exception {
        final BigDecimal primaryKey = new BigDecimal("100000");
        final SimpleTestSingleColumnPrimary18InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary18InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary18SelectIterator iterator = new SimpleTestSingleColumnPrimary18SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary18SelectRow row = iterator
                    .getSingleRow();
            // fV}^ƂĂ̔rs܂B
            assertTrue(primaryKey.compareTo(row.getFieldSmallmoney()) == 0);
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary18DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary18DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * timestamp^: oCi^
     * 
     * TODO: timestamp^INSERT͍쐬Ă͂Ȃ܂B 1.5.13ł͐Ă܂Ă܂B
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary20() throws Exception {
        final byte[] primaryKey = "ABCDE".getBytes();
        final SimpleTestSingleColumnPrimary20InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary20InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(
                    new ByteArrayInputStream(primaryKey), primaryKey.length);
            insertInvoker.executeSingleUpdate();

            fail("͒ʉ߂܂B");
        } catch (SQLException ex) {
            // B
        } finally {
            insertInvoker.close();
        }
    }

    /**
     * long: nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary21() throws Exception {
        final byte primaryKey = (byte) 0xff;
        final SimpleTestSingleColumnPrimary21InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary21InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary21SelectIterator iterator = new SimpleTestSingleColumnPrimary21SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary21SelectRow row = iterator
                    .getSingleRow();
            assertEquals(primaryKey, row.getFieldTinyint());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary21DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary21DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * UNIQUEIDENTIFIER: nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary22() throws Exception {
        final String primaryKey = "0088CCFF-9977-DD11-BBDD-00224466DDFF";
        final SimpleTestSingleColumnPrimary22InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary22InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary22SelectIterator iterator = new SimpleTestSingleColumnPrimary22SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary22SelectRow row = iterator
                    .getSingleRow();
            assertEquals(primaryKey, row.getFieldUniqueidentifier());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary22DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary22DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(primaryKey);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * oCi^
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary23() throws Exception {
        final byte[] primaryKey = "ABCDEFG".getBytes();
        final SimpleTestSingleColumnPrimary23InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary23InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(
                    new ByteArrayInputStream(primaryKey), primaryKey.length);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary23SelectAllIterator iterator = new SimpleTestSingleColumnPrimary23SelectAllIterator(
                fConn);
        try {
            assertTrue(iterator.next());
            final SimpleTestSingleColumnPrimary23SelectAllRow row = iterator
                    .getRow();
            // σoCił̂ŁA͎Iɒ܂B
            assertEquals(new String(primaryKey), new String(BlancoStreamUtil
                    .stream2Bytes(row.getFieldVarbinary())));
            assertFalse(iterator.next());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary23DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary23DeleteInvoker(
                fConn);
        try {
            deleteInvoker.setInputParameter(new ByteArrayInputStream(
                    (primaryKey)), primaryKey.length);
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }
    }

    /**
     * NVARCHAR: nB
     * 
     * @throws Exception
     */
    public void testSimpleTestSingleColumnPrimary24() throws Exception {
        final String primaryKey = "ABCDEFG123";
        final SimpleTestSingleColumnPrimary24InsertInvoker insertInvoker = new SimpleTestSingleColumnPrimary24InsertInvoker(
                fConn);
        try {
            insertInvoker.setInputParameter(primaryKey);
            insertInvoker.executeSingleUpdate();
        } finally {
            insertInvoker.close();
        }

        final SimpleTestSingleColumnPrimary24SelectIterator iterator = new SimpleTestSingleColumnPrimary24SelectIterator(
                fConn);
        try {
            iterator.setInputParameter(primaryKey);
            final SimpleTestSingleColumnPrimary24SelectRow row = iterator
                    .getSingleRow();
            assertEquals(primaryKey, row.getFieldVarchar());
        } finally {
            iterator.close();
        }

        final SimpleTestSingleColumnPrimary24SelectUpdatableIterator iteratorUpdatable = new SimpleTestSingleColumnPrimary24SelectUpdatableIterator(
                fConn);
        try {
            iteratorUpdatable.setInputParameter(primaryKey);
            assertTrue(iteratorUpdatable.next());
            final SimpleTestSingleColumnPrimary24SelectUpdatableRow row = iteratorUpdatable
                    .getRow();
            iteratorUpdatable.updateFieldVarchar("1234ABCD");
            iteratorUpdatable.updateRow();
            assertFalse(iteratorUpdatable.next());

            assertEquals(primaryKey, row.getFieldVarchar());
        } finally {
            iteratorUpdatable.close();
        }

        final SimpleTestSingleColumnPrimary24DeleteInvoker deleteInvoker = new SimpleTestSingleColumnPrimary24DeleteInvoker(
                fConn);
        try {
            // XV̒lō폜B
            deleteInvoker.setInputParameter("1234ABCD");
            deleteInvoker.executeSingleUpdate();
        } finally {
            deleteInvoker.close();
        }

    }
}
