/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;

import blanco.cg.BlancoCgTransformer;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * vO~O̎ނ܂钊ۓIȃgXtH[}[łB
 * 
 * @author IGA Tosiki
 */
abstract class AbstractBlancoCgTransformer implements BlancoCgTransformer {
    /**
     * R}hCɕ\ۂ̃bZ[WvtBbNXB
     */
    protected static final String CMDLINE_PREFIX = "cg: ";

    /**
     * \[Xt@C̊gq擾܂B
     * 
     * @return gqB
     */
    protected abstract String getSourceFileExt();

    /**
     * t@CNX܂̓C^tF[X瓱o܂B
     * 
     * ̃\bh́A܂t@Cm肵ĂȂꍇɂ̂݌Ăяo܂B
     * 
     * @param argSourceFile
     *            \[Xt@CIuWFNgB
     */
    protected void decideFilenameFromClassOrInterfaceName(
            final BlancoCgSourceFile argSourceFile) {
        // t@Cݒ̏ꍇɁABlancoCgSourceFile(t@C)̒Ɋ܂܂NXt@C݂̉܂B
        String className = null;
        for (int index = 0; index < argSourceFile.getClassList().size(); index++) {
            final Object objClass = argSourceFile.getClassList().get(index);
            if (objClass instanceof BlancoCgClass == false) {
                throw new IllegalArgumentException("NX̃XgɃNXȊǑ^["
                        + objClass.getClass().getName() + "]^܂B");
            }

            final BlancoCgClass cgClass = (BlancoCgClass) objClass;
            className = cgClass.getName();
            break;
        }

        if (className == null) {
            // ܂t@C肵ĂȂꍇɂ́AC^tF[ẌꗗNX̓o݂܂B
            for (int index = 0; index < argSourceFile.getInterfaceList().size(); index++) {
                final Object objClass = argSourceFile.getInterfaceList().get(
                        index);
                if (objClass instanceof BlancoCgInterface == false) {
                    throw new IllegalArgumentException(
                            "C^tF[X̃XgɃC^tF[XȊǑ^["
                                    + objClass.getClass().getName()
                                    + "]^܂B");
                }

                final BlancoCgInterface cgInterface = (BlancoCgInterface) objClass;
                className = cgInterface.getName();
                break;
            }
        }

        if (className == null) {
            // łNXm肵Ȃꍇɂ͗OƂĈ܂B
            throw new IllegalArgumentException(
                    "\[Xt@C̎w肪Ȃ̂ŃNX̃XgNX̊m݂܂ANX͊mł܂łB");
        }

        // \[Xt@C̊mȂ܂B
        // o[IuWFNg̃\[Xt@CXVĂ_ɒӂĂB
        argSourceFile.setName(className);
    }

    /**
     * \[XR[hC^[֏o͂܂B
     * 
     * java.lang.String̃XgC^[ւƏo͂܂B
     * 
     * @param argSourceLines
     *            \[XR[hsXgB
     * @param writer
     *            o͐惉C^B
     * @throws IOException
     *             o͗OꍇB
     */
    protected void source2Writer(final ArrayList argSourceLines,
            final BufferedWriter writer) throws IOException {
        for (int index = 0; index < argSourceLines.size(); index++) {
            final Object objLine = argSourceLines.get(index);
            if (objLine instanceof String == false) {
                throw new IllegalArgumentException(
                        "\[XR[hC^[ɏo͂鏈ɂāA\[XR[h̍s̃f[^StringȊǑ^ŗ^܂B");
            }

            // TODO As̏o͗}@\KvłB

            final String line = (String) objLine;
            writer.write(line);
            writer.newLine();
        }
    }
}
