/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgTransformer;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.ig.expander.ClassExpander;

/**
 * blancoCodeGenerator̃\[XR[hNXB
 * 
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public class ImplementGenerator {
    /**
     * blanco Framework̃IuWFNgt@NgB
     */
    private final BlancoCgObjectFactory fCgFactory = BlancoCgObjectFactory
            .getInstance();

    /**
     * blancoCg̃\[Xt@C\B
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * WJΏۂƂ blancoCodeGenerator̃NX\B
     */
    private final ArrayList fClassExpanderList = new ArrayList();

    /**
     * blancoCodeGeneratorƂĂ̐ݒB
     */
    private GeneratorSetting fSetting = null;

    /**
     * 񐶐Ώۂ testtH_(JUnitR[h)ł邩ǂB
     * 
     * TODO { ClassExpander̃CX^XƂɋLKvƍl܂B
     */
    private boolean isTest = false;

    /**
     * \[XR[hNX̃CX^X𐶐܂B
     * 
     * @param arg
     *            ݒ̃IuWFNgB
     */
    public ImplementGenerator(final GeneratorSetting arg) {
        fSetting = arg;
        fCgSourceFile = fCgFactory.createSourceFile("noname",
                "This code is generated by blanco Framework.");
    }

    /**
     * ʏ̃NXǉ܂B
     * 
     * @param argClass
     *            ʏ̃NXB
     */
    public void addMain(final ClassExpander argClass) {
        fClassExpanderList.add(argClass);
    }

    /**
     * eXgp̃NXǉ܂B
     * 
     * @param argClass
     *            eXgp̃NXB
     */
    public void addTest(final ClassExpander argClass) {
        fClassExpanderList.add(argClass);

        isTest = true;
    }

    /**
     * ݒ{Ƀ\[XR[h𐶐܂B
     * 
     * @throws IOException
     *             o͗OꍇB
     */
    public void generate() throws IOException {
        // NXWJB
        for (int index = 0; index < fClassExpanderList.size(); index++) {
            final ClassExpander argClass = (ClassExpander) fClassExpanderList
                    .get(index);
            argClass.expand();

            for (int indexSourceFileComment = 0; indexSourceFileComment < argClass
                    .getSourceFileComment().size(); indexSourceFileComment++) {
                final String strComment = (String) argClass
                        .getSourceFileComment().get(indexSourceFileComment);
                fCgSourceFile.getLangDoc().getDescriptionList().add(strComment);
            }

            if (argClass.getCgClass() != null) {
                fCgSourceFile.getClassList().add(argClass.getCgClass());
            } else {
                fCgSourceFile.getInterfaceList().add(argClass.getCgInterface());
            }
            fCgSourceFile.setPackage(argClass.getPackage());

            // importWJ܂B
            for (int indexImport = 0; indexImport < argClass.getImportList()
                    .size(); indexImport++) {
                final String newImport = (String) argClass.getImportList().get(
                        indexImport);
                fCgSourceFile.getImportList().add(newImport);
            }
        }

        final BlancoCgTransformer cgTransformer = BlancoCgTransformerFactory
                .getJavaSourceTransformer();
        if (isTest) {
            cgTransformer.transform(fCgSourceFile, new File(fSetting
                    .getWorkDirectory()
                    + "/test"));
        } else {
            cgTransformer.transform(fCgSourceFile, new File(fSetting
                    .getWorkDirectory()
                    + "/main"));
        }
    }
}
