package blanco.cg.expander;

import java.io.File;

import junit.framework.TestCase;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.MethodExpander;

public class ClassExpanderTest extends TestCase {
    public void testMain() throws Exception {
        final ClassExpander classExpander = new ClassExpander(new Type(
                "my.pkg", "MyClass")) {
            protected void expandClassStruct() {
                addFileComment("̃Tv͋@BIɐ܂B");
                getJavaDoc().addLine("͂߂ẴNX̃Tv<br>");
                getJavaDoc().addLine(
                        "̃TvblancoCodeGeneratorɂ@BIɎĂ܂B");
                addAnnotation("Copyright(value=IGA)");

                final FieldExpander field = new FieldExpander(new Type(
                        "java.util.Date"), "fDate");
                field.getJavaDoc().addLine("t̃tB[h̗");
                field.addAnnotation("Version(value=123)");
                addField(field);

                addMethod(new MethodExpander("myMethod") {
                    public void setupSignature() {
                        addUsingType(new Type("java.io.IOException"));

                        getJavaDoc().addLine("Rg̃eXg");
                        addAnnotation("Version(value=2006.02.02)");

                    }

                    public void implement() {
                        getData().addLine("if (true)");
                        getData().addLine("{");
                        getData().addLine("}");
                    }
                });
            }
        };
        new File("tmp/blanco").mkdirs();
        ClassExpander.generateJavaSource(classExpander, new File("tmp/blanco"));
    }
}
