/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * blanco Frameworkɂt@C֘Ã[eBeBW߂NXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoFileUtil {
    /**
     * fobO[hœ삷邩ǂ̃tOB
     */
    private static final boolean IS_DEUBG = false;

    /**
     * ^ꂽ̓t@Co̓t@CւƃRs[܂B
     * 
     * ̓t@C݂ȂꍇȂǂɂ͗O܂B
     * 
     * @param fileInput
     *            ̓t@CBnull͗^ȂłB
     * @param fileOutput
     *            o̓t@CBnull͗^ȂłB
     * @throws IOException
     *             o͗OꍇB
     */
    public static final void copy(final File fileInput, final File fileOutput)
            throws IOException {
        if (IS_DEUBG) {
            System.out.println("BlancoFileUtil.copy("
                    + fileInput.getAbsolutePath() + ", "
                    + fileOutput.getAbsolutePath() + ")");
        }
        if (fileInput == null) {
            throw new IllegalArgumentException("̓t@Cnull^܂B");
        }
        if (fileOutput == null) {
            throw new IllegalArgumentException("o̓t@Cnull^܂B");
        }
        if (fileInput.exists() == false) {
            throw new IllegalArgumentException("̓t@C["
                    + fileInput.getAbsolutePath() + "]܂B");
        }
        if (fileInput.isFile() == false) {
            throw new IllegalArgumentException("̓t@C["
                    + fileInput.getAbsolutePath() + "]ɃfBNg^邱Ƃ͂ł܂B");
        }
        if (fileOutput.exists()) {
            if (fileOutput.isFile() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileInput.getAbsolutePath() + "]ɃfBNg^邱Ƃ͂ł܂B");
            }
            if (fileOutput.canWrite() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileInput.getAbsolutePath()
                        + "]݂ɁA݂sƂł܂B");
            }
        }

        final File fileTargetParent = fileOutput.getParentFile();
        if (fileTargetParent.exists() == false) {
            // ݂Ȃꍇɂ͍쐬܂B
            if (fileTargetParent.mkdirs() == false) {
                throw new IllegalArgumentException("o̓t@C["
                        + fileInput.getAbsolutePath() + "]̐etH_["
                        + fileTargetParent.getAbsolutePath()
                        + "]݂Ȃ̂ō쐬悤Ƃ܂쐬Ɏs܂B");
            }
        }

        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(fileInput));
            outStream = new BufferedOutputStream(new FileOutputStream(
                    fileOutput));
            copy(inStream, outStream);
            outStream.flush();
        } finally {
            try {
                // Xg[JĂꍇɂ͊mɃN[Y܂B
                if (inStream != null) {
                    inStream.close();
                }
            } finally {
                // Xg[JĂꍇɂ͊mɃN[Y܂B
                if (outStream != null) {
                    outStream.close();
                }
            }
        }
    }

    /**
     * ^ꂽ̓Xg[o̓Xg[ւƃRs[܂B
     * 
     * obt@TCY8192oCgŃXg[ubNRs[܂B<br>
     * ̃\bh̓ł̓tbV͍s܂BKvɉČĂяo\bhɂ flush()ĂB
     * 
     * @param inStream
     *            ̓Xg[B
     * @param outStream
     *            o̓Xg[B
     * @throws IOException
     *             o͗OꍇB
     */
    public static final void copy(final InputStream inStream,
            final OutputStream outStream) throws IOException {
        if (inStream == null) {
            throw new IllegalArgumentException(
                    "BlancoFileUtil.copy\bh̓̓Xg[p[^null^܂BnullȊO̒lw肵ĂB");
        }
        if (outStream == null) {
            throw new IllegalArgumentException(
                    "BlancoFileUtil.copy\bh̏o̓Xg[p[^null^܂BnullȊO̒lw肵ĂB");
        }

        final byte[] buf = new byte[8192];
        for (;;) {
            final int length = inStream.read(buf, 0, buf.length);
            if (length < 0) {
                break;
            }
            outStream.write(buf, 0, length);
        }
    }
}
