/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * blanco Frameworkɂ Java\[XR[ho͂̂߂̃[eBeBW߂NXłB
 * 
 * ̃NX C#.NET̃\[XR[hp܂B
 * 
 * @author IGA Tosiki
 */
public final class BlancoJavaSourceUtil {
    /**
     * ^ꂽJava\[XR[hƂďo͂̂ƂăGXP[v܂B
     * 
     * /obNXbṼGXP[vщsR[h̃GXP[vs܂B<br>
     * ȊȌ͍s܂BƂ΃CWFNVUȂǂւ̑ϐ́Ã\bh͈܂B
     * 
     * @param originalString
     *            ͕
     * @return GXP[vsꂽ̕
     */
    public static final String escapeStringAsJavaSource(
            final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "BlancoJavaSourceUtil.escapeStringAsJavaSourceœ͈ᔽB̃\bhnullp[^Ƃė^܂BnullȊO̒l͂ĂB");
        }

        final StringReader reader = new StringReader(originalString);
        final StringWriter writer = new StringWriter();
        try {
            for (;;) {
                final int iRead = reader.read();
                if (iRead < 0) {
                    break;
                }
                switch (iRead) {
                case '\\':
                    writer.write("\\\\");
                    break;
                case '\n':
                    writer.write("\\n");
                    break;
                case '"':
                    writer.write("\\\"");
                    break;
                default:
                    writer.write((char) iRead);
                    break;
                }
            }
            writer.flush();
        } catch (IOException e) {
            // ɓĂ邱Ƃ́A肦܂B
            e.printStackTrace();
        }
        return writer.toString();
    }

    /**
     * ^ꂽJavaDocƂĈƂł̂ւƃGXP[v܂B JavaDocƂăGXP[vs܂B
     * 
     * HTMLƂẴGXP[vƓ̏s܂BhGXP[v܂B
     * 
     * @param originalString
     *            ͕
     * @return GXP[vsꂽ̕
     */
    public static final String escapeStringAsJavaDoc(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "BlancoJavaSourceUtil.escapeStringAsJavaDocœ͈ᔽB̃\bhnullp[^Ƃė^܂BnullȊO̒l͂ĂB");
        }

        final StringReader reader = new StringReader(originalString);
        final StringWriter writer = new StringWriter();
        try {
            for (;;) {
                final int iRead = reader.read();
                if (iRead < 0) {
                    break;
                }
                switch (iRead) {
                case '&':
                    writer.write("&amp;");
                    break;
                case '<':
                    writer.write("&lt;");
                    break;
                case '>':
                    writer.write("&gt;");
                    break;
                case '"':
                    writer.write("&quot;");
                    break;
                default:
                    writer.write((char) iRead);
                    break;
                }
            }
            writer.flush();
        } catch (IOException e) {
            // ɓĂ邱Ƃ́A肦܂B
            e.printStackTrace();
        }
        return writer.toString();
    }
}
