/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * blanco FrameworkɂXML֘Ã[eBeBW߂NXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoXmlUtil {
    /**
     * Iꂽm[h(Ggł)當擾܂B
     * 
     * m[hɂԂ炳ĂSẴeLXgf[^擾ꍇɗp܂B
     * 
     * @param nodeTarget
     *            ΏۂƂ^[Qbgm[h
     * @return 擾ꂽeLXg
     */
    public static final String getTextContent(final Node nodeTarget) {
        if (nodeTarget == null) {
            throw new IllegalArgumentException(
                    "m[heLXg擾郁\bhnull^܂BnullȊO̒l^悤ɂĂB");
        }

        String result = null;
        final NodeList listText = nodeTarget.getChildNodes();
        final int sizeChildList = listText.getLength();
        for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
            final Node nodeChild = listText.item(indexChild);
            if (nodeChild instanceof Text) {
                final Text textLook = (Text) nodeChild;
                result = (result == null ? textLook.getData() : result
                        + textLook.getData());
            }
        }
        return result;
    }

    /**
     * Ggw̃^O̕ǂݍ݂܂B
     * 
     * @param elementTarget
     *            ΏۂƂ^[QbgGg
     * @param tagName
     *            ^O
     * @return 擾ꂽeLXg
     */
    public static final String getTextContent(final Element elementTarget,
            final String tagName) {
        if (elementTarget == null) {
            throw new IllegalArgumentException(
                    "GgeLXg擾郁\bhɃGgƂnull^܂BnullȊO̒l^悤ɂĂB");
        }
        if (tagName == null) {
            throw new IllegalArgumentException(
                    "GgeLXg擾郁\bhɃ^OƂnull^܂BnullȊO̒l^悤ɂĂB");
        }

        String result = null;
        final NodeList listElementTarget = elementTarget
                .getElementsByTagName(tagName);
        final int sizeList = listElementTarget.getLength();
        for (int index = 0; index < sizeList; index++) {
            final Node nodeLook = listElementTarget.item(index);
            if (nodeLook instanceof Element) {
                final Element elementLook = (Element) nodeLook;

                final NodeList listText = elementLook.getChildNodes();
                final int sizeChildList = listText.getLength();
                for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
                    final Node nodeChild = listText.item(indexChild);
                    if (nodeChild instanceof Text) {
                        final Text textLook = (Text) nodeChild;
                        result = (result == null ? textLook.getData() : result
                                + textLook.getData());
                    }
                }
            }
        }
        return result;
    }

    /**
     * ^ꂽXMLt@CDOMc[ɕϊ܂B
     * 
     * Iɂ́AʓIɗpXMLϊAPIpĕϊs܂B
     * 
     * @param metaXmlSourceFile
     *            XMLt@C
     * @return oDOMc[
     * @throws IllegalArgumentException
     *             ̓t@CsłꍇBXMLϊ擾ɎsꍇȂǁB
     */
    public static final DOMResult transformFile2Dom(final File metaXmlSourceFile) {
        if (metaXmlSourceFile == null) {
            throw new IllegalArgumentException(
                    "t@C͂ƂDOMc[𐶐郁\bhnull^܂BnullȊO̒l^悤ɂĂB");
        }

        if (metaXmlSourceFile.exists() == false) {
            throw new IllegalArgumentException("XMLt@CDOMւ̕ϊ: w肳ꂽt@C["
                    + metaXmlSourceFile.getAbsolutePath() + "]܂łB");
        }
        if (metaXmlSourceFile.isFile() == false) {
            throw new IllegalArgumentException("XMLt@CDOMւ̕ϊ: w肳ꂽt@C["
                    + metaXmlSourceFile.getAbsolutePath()
                    + "]ۂɂ̓t@Cł͂܂łB");
        }
        if (metaXmlSourceFile.canRead() == false) {
            throw new IllegalArgumentException("XMLt@CDOMւ̕ϊ: w肳ꂽt@C["
                    + metaXmlSourceFile.getAbsolutePath() + "]ǂݍݕs\łB");
        }

        InputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(
                    metaXmlSourceFile));
            return transformStream2Dom(inStream);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "z肵ȂO: XMLϊɃt@CȂO܂B" + e.toString());
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException(
                            "z肵ȂO: XMLϊ̍Ō̃t@CN[YɁAo͗O܂B"
                                    + e.toString());
                }
            }
        }
    }

    /**
     * ^ꂽXMLXg[DOMc[ɕϊ܂B
     * 
     * Iɂ́AʓIɗpXMLϊAPIpĕϊs܂B
     * 
     * @param inXmlSource
     *            XMLXg[
     * @return oDOMc[
     * @throws IllegalArgumentException
     *             ̓t@CsłꍇBXMLϊ擾ɎsꍇȂǁB
     */
    public static final DOMResult transformStream2Dom(
            final InputStream inXmlSource) {
        if (inXmlSource == null) {
            throw new IllegalArgumentException(
                    "XMLXg[DOMc[ɕϊ鏈ɁAXg[Ƃnulln܂BXg[ɂnullȊO^ĂB");
        }

        try {
            final DOMResult result = new DOMResult();
            final TransformerFactory tf = TransformerFactory.newInstance();
            final Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inXmlSource), result);
            return result;
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "z肵ȂO: XMLϊRtBO[VO܂B" + e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException("z肵ȂO: XMLϊO܂B"
                    + e.toString());
        }
    }

    /**
     * ^ꂽDOMc[XMLt@Cɕϊ܂B
     * 
     * Iɂ́AʓIɗpXMLϊAPIpĕϊs܂B
     * 
     * @param document
     *            XMLhLg
     * @param metaXmlResultFile
     *            oXMLt@C
     * @throws IllegalArgumentException
     *             XMLc[słꍇBXMLϊ擾ɎsꍇȂǁB
     */
    public static final void transformDom2File(final Document document,
            final File metaXmlResultFile) {
        if (document == null) {
            throw new IllegalArgumentException(
                    "DOMXMLt@Cւ̕ϊ: XMLhLgnull^܂Ãp[^ɂnullȊO̒lw肷Kv܂B");
        }
        if (metaXmlResultFile == null) {
            throw new IllegalArgumentException(
                    "DOMXMLt@Cւ̕ϊ: oXMLt@Cnull^܂Ãp[^ɂnullȊO̒lw肷Kv܂B");
        }

        if (metaXmlResultFile.exists() == true
                && metaXmlResultFile.canWrite() == false) {
            throw new IllegalArgumentException("DOMXMLt@Cւ̕ϊ: w肳ꂽt@C["
                    + metaXmlResultFile.getAbsolutePath() + "]͏݂ł܂łB");
        }

        try {
            final OutputStream outStream = new BufferedOutputStream(
                    new FileOutputStream(metaXmlResultFile));
            try {
                transformDom2Stream(document, outStream);
                // Iꍇɂ̓tbVs܂B
                outStream.flush();
            } finally {
                outStream.close();
            }
        } catch (IOException e) {
            throw new IllegalArgumentException("DOMXMLt@Cւ̕ϊ: w肳ꂽt@C["
                    + metaXmlResultFile.getAbsolutePath()
                    + "]ւ̕ϊ̉ߒœo͗O܂B" + e.toString());
        }
    }

    /**
     * ^ꂽDOMc[XMLXg[ɕϊ܂B
     * 
     * Iɂ́AʓIɗpXMLϊAPIpĕϊs܂B
     * 
     * @param document
     *            XMLc[
     * @param oDOMXg[
     * @throws IllegalArgumentException
     *             p[^słꍇBXMLϊ擾ɎsꍇȂǁB
     */
    public static final void transformDom2Stream(final Document document,
            final OutputStream outXmlResult) {
        if (document == null) {
            throw new IllegalArgumentException(
                    "DOMc[oXMLXg[ɕϊ鏈ɁAXMLhLgƂnulln܂BXMLhLgɂnullȊO^ĂB");
        }
        if (outXmlResult == null) {
            throw new IllegalArgumentException(
                    "DOMc[oXMLXg[ɕϊ鏈ɁAXg[Ƃnulln܂BXg[ɂnullȊO^ĂB");
        }

        try {
            final DOMSource source = new DOMSource(document);
            final TransformerFactory tf = TransformerFactory.newInstance();
            final Transformer transformer = tf.newTransformer();
            transformer.transform(source, new StreamResult(outXmlResult));
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "z肵ȂO: XMLϊRtBO[VO܂B" + e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException("z肵ȂO: XMLϊO܂B"
                    + e.toString());
        }
    }

    /**
     * XMLhLgVK쐬܂B
     * 
     * hLgt@NghLgr_[擾AꂩXMLhLgVK쐬܂B
     * 
     * @return VKɍ쐬ꂽXMLhLgEIuWFNg
     * @throws IllegalArgumentException
     *             hLgr_[̐VK쐬ɎsꍇB
     */
    public static final Document newDocument() {
        final DocumentBuilderFactory builderFactory = DocumentBuilderFactory
                .newInstance();
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        } catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(
                    "hLgr_[(DocumentBuilder)̐VKɎs܂B" + e.toString());
        }
        return builder.newDocument();
    }

    /**
     * w̃GgɎw̃GgɂqGgǉ܂B
     * 
     * eLXg̎w肪΃eLXgm[hǉ܂BeLXgnullw肵ꍇɂ͎qGg̒ǉ݂̂s܂B
     * 
     * @param document
     *            XMLhLg
     * @param elementParent
     *            eGg
     * @param addElementName
     *            VGg̖O
     * @param addElementText
     *            VGgɒǉeLXgBnullw肵ꍇɂ̓eLXgǉ͏ȗB
     * @return
     */
    public static final void addChildElement(final Document document,
            final Element elementParent, final String addElementName,
            final String addElementText) {
        if (document == null) {
            throw new IllegalArgumentException(
                    "Ggǉ (addElementText) ɁAhLgƂnulln܂BnullȊO̒lw肵ĂB");
        }
        if (elementParent == null) {
            throw new IllegalArgumentException(
                    "Ggǉ (addElementText) ɁAeGgƂnulln܂BnullȊO̒lw肵ĂB");
        }
        if (addElementName == null) {
            throw new IllegalArgumentException(
                    "Ggǉ (addElementText) ɁAVGg̖OƂnulln܂BnullȊO̒lw肵ĂB");
        }
        if (addElementName.length() == 0) {
            throw new IllegalArgumentException(
                    "Ggǉ (addElementText) ɁAVGg̖OƂĒ0̕񂪓n܂B1ȏ̒̒lw肵ĂB");
        }

        // ŏɒǉGg𐶐܂B
        final Element elementAdd = document.createElement(addElementName);
        if (addElementText != null) {
            // eLXg̎w肪ꍇɂ̂ݒǉs܂B
            // eLXgm[h𐶐܂B
            final Text elemnetTextNode = document
                    .createTextNode(addElementText);
            // eLXgm[hGgɒǉ܂B
            elementAdd.appendChild(elemnetTextNode);
        }
        // ŌɐeGgɐVGgǉ܂B
        elementParent.appendChild(elementAdd);
    }

    /**
     * w̃Gg̃Gg܂B
     * 
     * @param path
     *            pX aaa/bbb ̂悤Ɏw肵܂B
     * @return 擾ꂽGg
     */
    public static final Element getElement(final Node nodeTarget,
            final String path) {
        if (nodeTarget == null) {
            throw new IllegalArgumentException(
                    "w̃GgGg郁\bh̃m[hnull^܂BnullȊO̒l^悤ɂĂB");
        }
        if (nodeTarget == null) {
            throw new IllegalArgumentException(
                    "w̃GgGg郁\bh̃pXnull^܂BnullȊO̒l^悤ɂĂB");
        }

        final String[] splitPath = BlancoNameUtil.splitPath(path);

        final NodeList nodeList = nodeTarget.getChildNodes();
        final int nodeLength = nodeList.getLength();
        for (int index = 0; index < nodeLength; index++) {
            final Node nodeLook = nodeList.item(index);
            if (nodeLook instanceof Element) {
                final Element elementLook = (Element) nodeLook;
                if (elementLook.getNodeName().equals(splitPath[0])) {
                    // qbg܂B
                    if (splitPath.length == 1) {
                        // System.out.println("܂B" +
                        // elementLook.getNodeName());
                        return elementLook;
                    } else {
                        // System.out.println("ċAs܂B" +
                        // elementLook.getNodeName());
                        return getElement(elementLook, path
                                .substring(splitPath[0].length() + 1));
                    }
                }
            }
        }
        // ł܂łB
        return null;
    }
}
