/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import blanco.dotnet.cg.expander.field.FieldExpanderDotNet;
import blanco.dotnet.cg.expander.implementor.ImplementDataDotNet;
import blanco.dotnet.cg.expander.javadoc.ClassJavaDocDotNet;
import blanco.dotnet.cg.expander.method.MethodExpanderDotNet;
import blanco.dotnet.cg.generator.GeneratorSettingDotNet;
import blanco.dotnet.cg.generator.ImplementGeneratorDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 */
public abstract class ClassExpanderDotNet extends ExpanderDotNet {
    private TypeDotNet _type = null;

    private ImportListDotNet _importList2 = new ImportListDotNet();

    private ImplementDataDotNet _staticImplement = new ImplementDataDotNet();

    private List _fieldList = new ArrayList();

    private Map _filedMap = new Hashtable();

    private List _interfaceList = new ArrayList();

    private List _methodList = new ArrayList();

    private List _code = null;

    private boolean _existSuperClass = false;

    private TypeDotNet _superClass = null;

    private ClassJavaDocDotNet _javaDoc = new ClassJavaDocDotNet();

    private List _fileComments = new ArrayList();

    /**
     * 4󔒂ŃCfgƂ܂B
     */
    public static final String INDENT = "    ";

    protected boolean isInterface() {
        return false;
    }

    protected final boolean isStatic() {
        return false;
    }

    public static final TypeDotNet adjust(TypeDotNet type) {
        TypeDotNet result = new TypeDotNet(type.getNameSpace(), type.getName());
        return result;
    }

    public ClassExpanderDotNet(TypeDotNet type) {
        _type = adjust(type);

        createFileComment();
    }

    public void createFileComment() {
        addFileComment("This code is generated by blanco Framework.");
    }

    public void addFileComment(String comment) {
        _fileComments.add(comment);
    }

    public ClassJavaDocDotNet getJavaDoc() {
        return _javaDoc;
    }

    public void addImport(TypeDotNet type) {
        _importList2.add(type);
    }

    public void addImport(List listType) {
        for (Iterator ite = listType.iterator(); ite.hasNext();) {
            addImport((TypeDotNet) ite.next());
        }
    }

    public void addField(FieldExpanderDotNet field) {
        addImport(field.getTypeValue().getType());
        addImport(field.getUsingTypeList());
        _fieldList.add(field);
        _filedMap.put(field.getTypeValue().getName(), field);
    }

    public void setSuperClass(TypeDotNet type) {
        _existSuperClass = true;
        addImport(type);
        _superClass = type;
    }

    protected boolean existSuperClass() {
        return _existSuperClass;
    }

    protected FieldExpanderDotNet getField(int index) {
        return (FieldExpanderDotNet) _fieldList.get(index);
    }

    protected FieldExpanderDotNet getField(String name) {
        return (FieldExpanderDotNet) _filedMap.get(name);
    }

    public ValueDotNet getFieldValue(String fieldName) {
        ValueDotNet result = null;
        Iterator i = _fieldList.iterator();
        FieldExpanderDotNet field = null;
        while (i.hasNext()) {
            field = (FieldExpanderDotNet) i.next();
            if (field.getTypeValue().getName().equals(fieldName)) {
                result = field.getFieldValue();
                break;
            }
        }
        return result;
    }

    protected int getFieldCount() {
        return _fieldList.size();
    }

    public void addMethod(MethodExpanderDotNet method) {
        _methodList.add(method);
        method.setupSignature();
        method.setClassSource(this);
    }

    protected MethodExpanderDotNet getMethod(int index) {
        return (MethodExpanderDotNet) _methodList.get(index);
    }

    protected int getMethodCount() {
        return _methodList.size();
    }

    public void addInterface(TypeDotNet type) {
        addImport(type);
        _interfaceList.add(type);
    }

    protected void implementStaticBlock() {
    }

    protected abstract void expandClassStruct();

    private void implementAll() {
        implementStaticBlock();
        addImport(_staticImplement.getUsingTypeList());

        MethodExpanderDotNet m = null;
        for (int i = 0; i < getMethodCount(); i++) {
            m = getMethod(i);
            m.implement();
            addImport(m.getUsingTypeList());
        }
    }

    public final List expand() {

        expandClassStruct();
        implementAll();

        _code = new ArrayList();

        if (_fileComments.size() != 0) {
            _code.add("/*");
            for (int i = 0; i < _fileComments.size(); i++) {
                _code.add(" * " + _fileComments.get(i));
            }
            _code.add(" */");
        }

        _code.addAll(_importList2.expand());
        _code.add("");

        if (!_type.getNameSpace().equals("")) {
            _code.add("namespace " + getNameSpace());
            _code.add("{");
        }

        if (!_javaDoc.isEmpty()) {
            List list = _javaDoc.expand();
            for (int i = 0; i < list.size(); i++) {
                _code.add(list.get(i));
            }
        }

        if (getAnnotationList().isEmpty() == false) {
            // NX̃Ame[VWJ܂B
            for (int index = 0; index < getAnnotationList().size(); index++) {
                _code.add(INDENT + "["
                        + (String) getAnnotationList().get(index) + "]");
            }
        }

        _code.add(getClassDeclaration());
        _code.add(INDENT + "{");

        expandAllFields();
        _code.add("");

        expandStaticBlock();
        _code.add("");

        expandAllMethod();
        _code.add(INDENT + "}");

        // OԂ̏IuPbg
        _code.add("}");
        return _code;
    }

    private void expandStaticBlock() {
        if (!_staticImplement.isEmpty()) {
            _code.add(INDENT + "static {");
            List codes = _staticImplement.getImplementList();
            for (int i = 0; i < codes.size(); i++) {
                _code.add(codes.get(i));
            }
            _code.add(INDENT + "}");

        }
    }

    private void expandAllMethod() {
        for (int i = 0; i < getMethodCount(); i++) {
            if (i != 0) {
                _code.add("");
            }
            makeMethodCode(getMethod(i));
        }
    }

    private void expandAllFields() {
        for (int i = 0; i < getFieldCount(); i++) {
            if (i != 0) {
                _code.add("");
            }
            makeFieldCode(getField(i));
        }
    }

    private String getClassDeclaration() {
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT + "public");
        if (isAbstract()) {
            sb.append(" abstract");
        }
        if (isInterface()) {
            sb.append(" interface ");
        } else {
            sb.append(" class ");
        }
        sb.append(_type.getName());
        if (existSuperClass()) {
            sb.append(" : ");
            sb.append(_superClass.getName());
        }

        if (!_interfaceList.isEmpty()) {
            sb.append(" implements");
            Iterator i = _interfaceList.iterator();
            TypeDotNet type = null;

            if (i.hasNext()) {
                type = (TypeDotNet) i.next();
                sb.append(" ");
                sb.append(type.getName());
            }

            while (i.hasNext()) {
                type = (TypeDotNet) i.next();
                sb.append(", ");
                sb.append(type.getName());
            }
        }

        return new String(sb);
    }

    private void makeMethodCode(MethodExpanderDotNet method) {
        List methodCode = method.expand();
        for (int i = 0; i < methodCode.size(); i++) {
            _code.add(methodCode.get(i));
        }
    }

    private void makeFieldCode(FieldExpanderDotNet field) {
        List fieldCode = field.expand();

        for (int i = 0; i < fieldCode.size(); i++) {
            _code.add(fieldCode.get(i));
        }
    }

    public String getName() {
        return _type.getName();
    }

    public String getNameSpace() {
        return _type.getNameSpace();
    }

    public TypeDotNet getType() {
        return _type;
    }

    protected ImplementDataDotNet getStaticImplementData() {
        return _staticImplement;
    }

    public void clear() {
        _fieldList.clear();

        MethodExpanderDotNet method = null;
        Iterator i = _methodList.iterator();
        while (i.hasNext()) {
            method = (MethodExpanderDotNet) i.next();
            method.clear();
        }
        _methodList.clear();
        _fileComments.clear();
        _javaDoc = null;
        _staticImplement = null;
        _code.clear();
        _importList2.clear();
    }

    /**
     * ClassExpander͂ƂJava\[XR[ho͂܂B
     * 
     * @param classExpander
     * @param directoryTarget
     */
    public static void generateJavaSource(
            final ClassExpanderDotNet classExpander, final File directoryTarget) {
        final GeneratorSettingDotNet setting = new GeneratorSettingDotNet();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(directoryTarget.getAbsolutePath());
        final ImplementGeneratorDotNet implementGenerator = new ImplementGeneratorDotNet(
                setting);
        // 쐬NXo^܂B
        implementGenerator.addMain(classExpander);
        try {
            // ۂɃ\[XR[hs܂B
            implementGenerator.generate();
            // System.out.println("\[XR[h܂B");
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\[XR[hɓo͗O܂B:"
                    + e.toString());
        }
    }
}
