/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.expander.method;

import java.util.ArrayList;
import java.util.List;

import blanco.dotnet.cg.expander.ClassExpanderDotNet;
import blanco.dotnet.cg.expander.ExpanderDotNet;
import blanco.dotnet.cg.expander.TypeDotNet;
import blanco.dotnet.cg.expander.ValueDotNet;
import blanco.dotnet.cg.expander.implementor.ImplementDataDotNet;
import blanco.dotnet.cg.expander.javadoc.MethodJavaDocDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX
 * 
 * @author IGA Tosiki
 */
public abstract class MethodExpanderDotNet extends ExpanderDotNet {
    private TypeDotNet _returnType = new TypeDotNet("void");

    private String _name = "";

    private ArrayList _arguments = new ArrayList();

    private List _code = new ArrayList();

    private MethodJavaDocDotNet _javaDoc = new MethodJavaDocDotNet();

    private ImplementDataDotNet _data = null;

    private ClassExpanderDotNet _classExpander;

    /**
     * q
     */
    private String fBase = null;

    public MethodExpanderDotNet(String name) {
        _name = name;
        _classExpander = null;
        _data = new ImplementDataDotNet();
    }

    /**
     * RXgN^̏qݒ肵܂B
     * 
     * RXgN^̏ꍇɂ̂ݗpł܂B<br>
     * : public MyClass(int value1) : base(value1, 0)
     * 
     * @param argBase
     *            qBȂAq̋Lq̒́uvalue1, 0v^܂B
     */
    public void setBase(final String argBase) {
        fBase = argBase;
    }

    protected ImplementDataDotNet getData() {
        return _data;
    }

    protected List getImplementList() {
        return _data.getImplementList();
    }

    protected MethodJavaDocDotNet getJavaDoc() {
        return _javaDoc;
    }

    public List getUsingTypeList() {
        return _data.getUsingTypeList();
    }

    public void addArgument(ValueDotNet argument) {
        addUsingType(argument.getType());
        _arguments.add(argument);
    }

    protected final int getArgumentCount() {
        return _arguments.size();
    }

    protected final ValueDotNet getArgument(int index) {
        return (ValueDotNet) _arguments.get(index);
    }

    protected void addUsingType(TypeDotNet type) {
        _data.getUsingTypeList().add(type);
    }

    protected boolean isStatic() {
        return false;
    }

    /**
     * ̃\bhI[oCh\bhǂB
     * 
     * @return false:I[oChɂ炸B true:I[oCh\bhłB
     */
    protected boolean isOverride() {
        return false;
    }

    protected String makeSignature() {
        return makeSignature(false);
    }

    protected String makeSignature(boolean isConstructor) {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassExpanderDotNet.INDENT + ClassExpanderDotNet.INDENT);
        sb.append(getScope().get());

        if (!isConstructor) {
            if (isStatic()) {
                sb.append(" static");
            }
            if (isAbstract()) {
                sb.append(" abstract");
            }
            if (isOverride()) {
                // \bh̃I[oChł o͂܂B
                sb.append(" override");
            }
            sb.append(" ");
            sb.append(getReturnType().getName());
        }
        sb.append(" ");
        sb.append(_name);
        sb.append("(");
        for (int i = 0; i < getArgumentCount(); i++) {
            if (i != 0) {
                sb.append(", ");
            }

            sb.append(getArgument(i).getType().getName());
            sb.append(" ");
            sb.append(getArgument(i).getName());
        }
        sb.append(")");

        if (fBase != null) {
            // q𖄂ߍ݂܂B
            sb.append(" : base(" + fBase + ")");
        }

        if (isAbstract()) {
            sb.append(";");
        } else {
            // Ō̃uPbg(JavaƂ͈قȂ)t^܂B
        }
        return new String(sb);
    }

    public abstract void implement();

    public abstract void setupSignature();

    public List expand() {
        if (!_javaDoc.isEmpty()) {
            List list = _javaDoc.expand();
            for (int i = 0; i < list.size(); i++) {
                _code.add(ClassExpanderDotNet.INDENT + list.get(i));
            }
        }
        if (getAnnotationList().isEmpty() == false) {
            // \bh̃Ame[VWJ܂B
            for (int index = 0; index < getAnnotationList().size(); index++) {
                _code.add(ClassExpanderDotNet.INDENT
                        + ClassExpanderDotNet.INDENT + "["
                        + (String) getAnnotationList().get(index) + "]");
            }
        }
        _code.add(makeSignature());
        if (!isAbstract()) {
            _code.add(ClassExpanderDotNet.INDENT + ClassExpanderDotNet.INDENT
                    + "{");
        }

        // ̖{́B
        _code.addAll(_data.getImplementList());

        if (!isAbstract()) {
            _code.add(ClassExpanderDotNet.INDENT + ClassExpanderDotNet.INDENT
                    + "}");
        }
        return _code;
    }

    public List getCode() {
        return _code;
    }

    public TypeDotNet getReturnType() {
        return _returnType;
    }

    protected void setReturnType(TypeDotNet type) {
        addUsingType(type);
        _returnType = type;
    }

    public String getName() {
        return _name;
    }

    protected ValueDotNet getField(String name) {
        return _classExpander.getFieldValue(name);
    }

    public void setClassSource(ClassExpanderDotNet classSource) {
        _classExpander = classSource;
        for (int i = 0; i < _data.getUsingTypeList().size(); i++) {
            _classExpander.addImport((TypeDotNet) _data.getUsingTypeList().get(
                    i));
        }
        _data.getUsingTypeList().clear();
    }

    public void clear() {
        _arguments = null;
        _code = null;
        _data = null;
        _javaDoc = null;
    }
}
