/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dotnet.cg.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import blanco.dotnet.cg.expander.ClassExpanderDotNet;
import blanco.dotnet.cg.io.SourceWriterDotNet;

/**
 * .NET Frameworkp CodeGenerator֘ANX<br>
 * ۂɃ\[XR[hs{̃NXłB
 * 
 * @author IGA Tosiki
 */
public final class ImplementGeneratorDotNet extends AbstructGeneratorDotNet {
    private String _pathSeparator = "/";

    private List _mainClassList = new ArrayList();

    private List _testClassList = new ArrayList();

    private GeneratorSettingDotNet _setting = null;

    private SourceWriterDotNet _writer = null;

    public ImplementGeneratorDotNet(GeneratorSettingDotNet setting) {
        _setting = setting;
    }

    public void generateMain() throws IOException {
        String outputDirectory = _setting.getMainOutputDirectory();
        // "CNX̐Jn܂Bo̓fBNg:" + outputDirectory);

        for (int i = 0; i < _mainClassList.size(); i++) {
            generateClass(outputDirectory, (ClassExpanderDotNet) _mainClassList
                    .get(i));
        }
    }

    public void generateTest() throws IOException {
        String outputDirectory = _setting.getTestOutputDirectory();
        // "eXgNX̐Jn܂Bo̓fBNg:" + outputDirectory

        for (int i = 0; i < _testClassList.size(); i++) {
            generateClass(outputDirectory, (ClassExpanderDotNet) _testClassList
                    .get(i));
        }
    }

    private void generateClass(String outputDirectory,
            ClassExpanderDotNet classExpander) throws IOException {
        String path = getOutputPath(outputDirectory, classExpander);
        _writer = new SourceWriterDotNet(_setting.getSoruceEncoding());
        _writer.write(path, classExpander.expand());

        String name = classExpander.getType().getFullName();
        if (_writer.isCreated()) {
            System.out.println("NX:" + name);
        } else if (_writer.isUpdated()) {
            System.out.println("XVNX:" + name);
        }
        classExpander.clear();
    }

    public String getOutputFileName(ClassExpanderDotNet classSource) {
        return classSource.getName() + ".cs";
    }

    public String getOutputPath(String outputDirectory,
            ClassExpanderDotNet classSource) {
        StringBuffer sb = new StringBuffer();
        sb.append(getOutputDirectory(outputDirectory, classSource));
        sb.append(_pathSeparator);
        sb.append(getOutputFileName(classSource));
        return new String(sb);
    }

    public String getOutputDirectory(String outputDirectory,
            ClassExpanderDotNet classSource) {
        String path = getNameSpaceToPath(classSource.getNameSpace());
        return outputDirectory + _pathSeparator + path;
    }

    private String getNameSpaceToPath(String nameSpace) {
        return nameSpace.replaceAll("\\.", _pathSeparator);
    }

    public void addMain(ClassExpanderDotNet expander) {
        _mainClassList.add(expander);
    }

    public void addTest(ClassExpanderDotNet expander) {
        _testClassList.add(expander);
    }

    public void generateRuntime() throws IOException {
    }
}
