/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoXmlUtil;
import blanco.csv.expand.BlancoCsvExpandIOExceptionDotNet;
import blanco.csv.expand.BlancoCsvExpandReaderDotNet;
import blanco.csv.expand.BlancoCsvExpandRecordDotNet;
import blanco.csv.expand.BlancoCsvExpandRuntimeUtilDotNet;
import blanco.csv.expand.BlancoCsvExpandWriterDotNet;
import blanco.csv.resourcebundle.BlancoCsvDotNetResourceBundle;
import blanco.csv.valueobject.BlancoCsvFieldStructureDotNet;
import blanco.csv.valueobject.BlancoCsvStructureDotNet;

public class BlancoCsvXml2CsClass {
    private final BlancoCsvDotNetResourceBundle bundle = new BlancoCsvDotNetResourceBundle();

    private String fRuntimePackage = null;

    /**
     * ^ꂽԃt@CA^ꂽԃfBNgpȂA^[QbgfBNgɐ܂B
     * 
     * @param fileXmlSource
     *            ԃt@C
     * @param runtimePackage
     *            ^CpbP[WBw̏ꍇɂ͒`̒l𗘗pB
     * @param directoryValueObjectWork
     *            VÔ߂̃[NfBNgB
     * @param directoryBlancoTarget
     *            \[XR[ho͐ blanco tH_B
     * @throws TransformerException
     *             XMLϊOꍇB
     */
    public void process(final File fileXmlSource, final String runtimePackage,
            final File directoryValueObjectWork,
            final File directoryBlancoTarget) throws TransformerException {
        fRuntimePackage = runtimePackage;

        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fileXmlSource);

        try {
            final Node rootNode = result.getNode();
            if (rootNode instanceof Document) {
                // ꂪnBhLg[g擾
                final Document rootDocument = (Document) rootNode;
                final NodeList listSheet = rootDocument
                        .getElementsByTagName("sheet");
                final int sizeListSheet = listSheet.getLength();
                for (int index = 0; index < sizeListSheet; index++) {
                    final Element elementSheet = (Element) listSheet
                            .item(index);

                    final NodeList listCommon = elementSheet
                            .getElementsByTagName("blancocsvdotnet-common");
                    if (listCommon.getLength() == 0) {
                        // blancocsv-commonꍇɂ̓XLbv܂B
                        continue;
                    }

                    final Element elementCommon = (Element) listCommon.item(0);

                    final BlancoCsvStructureDotNet processStructure = new BlancoCsvStructureDotNet();

                    processStructure.setFileDefinitionId(BlancoXmlUtil
                            .getTextContent(elementCommon, "fileDefinitionId"));
                    if (processStructure.getFileDefinitionId() == null) {
                        // t@C`ID`̂̂͏XLbv܂B
                        continue;
                    }

                    processStructure.setPackageName(BlancoXmlUtil
                            .getTextContent(elementCommon, "packageName"));
                    if (processStructure.getPackageName() == null) {
                        throw new IllegalArgumentException(bundle
                                .getXml2javaclassErr001(processStructure
                                        .getFileDefinitionId()));
                    }

                    processStructure.setFileDescription(BlancoXmlUtil
                            .getTextContent(elementCommon, "fileDescription"));

                    final String csvDelimiter = BlancoXmlUtil.getTextContent(
                            elementCommon, "csvDelimiter");
                    if (csvDelimiter == null) {
                        throw new IllegalArgumentException(bundle
                                .getXml2javaclassErr002(processStructure
                                        .getFileDefinitionId()));
                    }

                    //  CSṼf~^m肳邽߂̏łB
                    // ܂CSVf~^L܂B
                    processStructure.setDelimiter(csvDelimiter);
                    if (csvDelimiter.equals("option")) {
                        final String optionCsvDelimiter = BlancoXmlUtil
                                .getTextContent(elementCommon,
                                        "optionCsvDelimiter");
                        if (optionCsvDelimiter == null) {
                            throw new IllegalArgumentException(bundle
                                    .getXml2javaclassErr003(processStructure
                                            .getFileDefinitionId()));
                        }

                        // IvVCSVf~^w肳Ă̂ŁA𗘗p܂B
                        processStructure.setDelimiter(optionCsvDelimiter);
                    }

                    // ^CpbP[W̊mB
                    if (fRuntimePackage != null
                            && fRuntimePackage.trim().length() > 0) {
                        // ^CpbP[W̎w肪ꍇɂ͂𗘗p܂B
                        processStructure.setRuntimePackage(fRuntimePackage);
                    } else {
                        // ^CpbP[W̎w肪Ȃꍇɂ́A`̃pbP[W𗘗p܂B
                        processStructure.setRuntimePackage(processStructure
                                .getPackageName());
                    }

                    final String titleRow = BlancoXmlUtil.getTextContent(
                            elementCommon, "titleRow");
                    if (titleRow != null) {
                        processStructure.setTitleRow(titleRow);
                    }

                    final NodeList listRow = elementSheet
                            .getElementsByTagName("field");
                    final int sizeListRow = listRow.getLength();
                    for (int indexField = 0; indexField < sizeListRow; indexField++) {
                        final Element elementField = (Element) listRow
                                .item(indexField);

                        final BlancoCsvFieldStructureDotNet field = new BlancoCsvFieldStructureDotNet();

                        field.setName(BlancoXmlUtil.getTextContent(
                                elementField, "name"));
                        if (field.getName() == null) {
                            continue;
                        }

                        field.setType(BlancoXmlUtil.getTextContent(
                                elementField, "type"));
                        field.setNo(BlancoXmlUtil.getTextContent(elementField,
                                "no"));
                        field.setDescription(BlancoXmlUtil.getTextContent(
                                elementField, "description"));
                        field.setMinLength(BlancoXmlUtil.getTextContent(
                                elementField, "minLength"));
                        field.setMaxLength(BlancoXmlUtil.getTextContent(
                                elementField, "maxLength"));
                        field.setDefault(BlancoXmlUtil.getTextContent(
                                elementField, "default"));
                        field.setFormat(BlancoXmlUtil.getTextContent(
                                elementField, "format"));

                        if (field.getType() == null) {
                            throw new IllegalArgumentException(bundle
                                    .getXml2javaclassErr004(processStructure
                                            .getFileDefinitionId(), field
                                            .getName()));
                        }
                        if (field.getType().equals("System.DateTime")) {
                            if (field.getFormat() == null) {
                                throw new IllegalArgumentException(bundle
                                        .getXml2javaclassErr005(
                                                processStructure
                                                        .getFileDefinitionId(),
                                                field.getName()));
                            }
                        } else {
                            if (field.getFormat() != null) {
                                throw new IllegalArgumentException(bundle
                                        .getXml2javaclassErr006(
                                                processStructure
                                                        .getFileDefinitionId(),
                                                field.getName()));
                            }
                        }

                        if (field.getMinLength() != null) {
                            try {
                                if (Integer.parseInt(field.getMinLength()) < 0) {
                                    // 0ȏ݂̐̂w\
                                    throw new IllegalArgumentException(
                                            bundle
                                                    .getXml2javaclassErr007(
                                                            processStructure
                                                                    .getFileDefinitionId(),
                                                            field.getName(),
                                                            field
                                                                    .getMinLength()));
                                }
                            } catch (NumberFormatException ex) {
                                throw new IllegalArgumentException(bundle
                                        .getXml2javaclassErr008(
                                                processStructure
                                                        .getFileDefinitionId(),
                                                field.getName(), field
                                                        .getMinLength()));
                            }
                        }

                        if (field.getMaxLength() != null) {
                            try {
                                if (Integer.parseInt(field.getMaxLength()) < 0) {
                                    // 0ȏ݂̐̂w\
                                    throw new IllegalArgumentException(
                                            bundle
                                                    .getXml2javaclassErr009(
                                                            processStructure
                                                                    .getFileDefinitionId(),
                                                            field.getName(),
                                                            field
                                                                    .getMaxLength()));
                                }
                            } catch (NumberFormatException ex) {
                                throw new IllegalArgumentException(bundle
                                        .getXml2javaclassErr010(
                                                processStructure
                                                        .getFileDefinitionId(),
                                                field.getName(), field
                                                        .getMaxLength()));
                            }
                        }

                        if (field.getMinLength() != null
                                && field.getMaxLength() != null) {
                            // 召֌W`FbNB
                            if (Integer.parseInt(field.getMinLength()) > Integer
                                    .parseInt(field.getMaxLength())) {
                                throw new IllegalArgumentException(bundle
                                        .getXml2javaclassErr011(
                                                processStructure
                                                        .getFileDefinitionId(),
                                                field.getName(), field
                                                        .getMinLength(), field
                                                        .getMaxLength()));
                            }
                        }

                        processStructure.getListField().add(field);
                    }

                    expandSheet(processStructure, elementSheet, elementCommon,
                            directoryValueObjectWork, directoryBlancoTarget);
                }
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /**
     * V[gWJ܂B
     * 
     * @param elementSheet
     * @param elementCommon
     * @param directoryValueObjectWork
     * @param directoryTarget
     * @param isGenerateJUnit
     * @throws IOException
     * @throws TransformerException
     */
    private static void expandSheet(
            final BlancoCsvStructureDotNet processStructure,
            final Element elementSheet, final Element elementCommon,
            final File directoryValueObjectWork, final File directoryTarget)
            throws IOException, TransformerException {
        // ŏɃR[hWJ邱ƂƂ܂B
        // R[h̏̒ɑÓ`FbNȂǂ܂߂邱ƂƂ܂B
        BlancoCsvExpandRecordDotNet.expand(processStructure,
                directoryValueObjectWork, directoryTarget);
        new BlancoCsvExpandReaderDotNet().expand(processStructure,
                directoryTarget);
        new BlancoCsvExpandWriterDotNet().expand(processStructure,
                directoryTarget);

        new BlancoCsvExpandIOExceptionDotNet().expand(processStructure,
                directoryTarget);
        new BlancoCsvExpandRuntimeUtilDotNet().expand(processStructure,
                directoryTarget);
    }
}
