/*
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package blanco.uno.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import blanco.report.resourcebundle.BlancoUnoResourceBundle;

/**
 * BlancoUnoLauncher (OpenOffice.org `[NX)
 * 
 * ̃vÓAOpenOffice.org풓̃`vOłB <br>
 * OpenOffice.org풓̋NEIS܂B OpenOffice.org 2.0.0 {+Windows XP
 * SP2œmF܂B <br>
 * ̃vOWindows XPȍ~ŗLł (Windows XP TASKKILLR}h𗘗pĂ܂) <br>
 * I[v\[X(Seasar Software License)̂ƂŌJĂ S2Joo x[XɃJX^}CYč쐬܂B <br>
 * ̂߁ACZX́uThe Seasar Software License, Version 1.1vɏ܂B
 * 
 * : {IɃXbhZ[tł́u܂vBȂȂ瑊肪vZXł邩łB̃NX̗p҂VOœ삷悤ɐ䂵ĂB
 * 
 * @author makotan: http://d.hatena.ne.jp/makotan/ (IWi)
 * @author igapyon: tosiki.iga@nifty.ne.jp (HĒ܂)
 * @version 2005/03/04 OOoLaunchero[W쐬
 * @version 2005/11/21 BlancoUnoLauncheȑo[W̍쐬
 */
public class BlancoUnoLauncher {
    private final BlancoUnoResourceBundle bundle = new BlancoUnoResourceBundle();

    private static final boolean IS_DEBUG = false;

    private String unoLauncherOpenofficeLoadmodule = null;

    /**
     * OpenOffice.org̃vZXL܂B
     */
    private Process procOOo = null;

    public BlancoUnoLauncher() {
        // lɂ̓\[Xoh̒lݒ肵܂B
        unoLauncherOpenofficeLoadmodule = bundle
                .getUnoLauncherOpenofficeLoadmodule();
    }

    /**
     * OpenOffice.org 2.0̃W[̃pXύX܂B
     * 
     * @param modulePath
     */
    public void setUnoLauncherOpenofficeLoadmodule(final String modulePath) {
        unoLauncherOpenofficeLoadmodule = modulePath;
    }

    /**
     * OpenOffice.orgvZXN܂B <br>
     * 
     * ̃\bh̓vZXN{I܂B<br>
     * O ensureStop()\bhĂяoĂƁAsvȃvZX̒~mFł܂B
     */
    public void start() {
        File fileCheck = new File(unoLauncherOpenofficeLoadmodule);
        if (fileCheck.exists() == false) {
            throw new IllegalArgumentException("OpenOffice.org[hW[ ["
                    + fileCheck + "] ̃t@C܂ł.");
        }

        try {
            if (IS_DEBUG) {
                System.out.println("OpenOffice.org[hW[ ["
                        + unoLauncherOpenofficeLoadmodule + "] ["
                        + bundle.getUnoLauncherOpenofficeExecparam()
                        + "] N܂.");
            }
            procOOo = Runtime.getRuntime().exec(
                    new String[] { unoLauncherOpenofficeLoadmodule,
                            bundle.getUnoLauncherOpenofficeExecparam() });
        } catch (IOException ex) {
            throw new IllegalArgumentException("OpenOffice.org[hW[ ["
                    + unoLauncherOpenofficeLoadmodule + "] ["
                    + bundle.getUnoLauncherOpenofficeExecparam()
                    + "] ̋NɎs܂.: " + ex.toString());
        }
    }

    /**
     * OpenOffice.orgvZX~Ă邱Ƃ̔OmF{܂B
     */
    public void ensureStop() {
        if (IS_DEBUG) {
            System.out.println("OpenOffice.org~Ă邱ƂOmF܂B");
        }

        try {
            // TASKKILLpH
            Process procKill = Runtime.getRuntime().exec(loadKillCommand());
            // killR}h̏I҂܂B
            procKill.waitFor();
        } catch (IOException ex1) {
            throw new IllegalArgumentException(
                    "OpenOffice.org̋~R}h ["
                            + loadKillCommand()[0]
                            + "] s܂BR}hÓǂmFĂB"
                            + "ȂAWindows 2000ȑOOSɂāATASKKILLR}h͎ĂȂ̂ŁÃR}h͕Ks܂B");
        } catch (InterruptedException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficevZX~R}h̋N̋K莞Ԃ̑ҋ@Ɋ荞݂܂.: "
                            + ex.toString());
        }
    }

    /**
     * OpenOffice.orgvZX~܂B
     */
    public void stop() {
        if (procOOo == null) {
            return;
        }

        // OpenOffice.org̃vZXj܂BȂ WindowsłOpenOffice.org 2.0ȍ~ł
        // soffice.exesoffice.binƂʃvZXł̂ŁȀ͗Lɋ@\܂B
        procOOo.destroy();

        // DestoryAwbҋ@܂B
        try {
            Thread.sleep(Integer.parseInt(bundle
                    .getUnoLauncherOpenofficeWaitEnd()));
        } catch (InterruptedException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficevZX~˗s̋K莞Ԃ̑ҋ@Ɋ荞݂܂.: "
                            + ex.toString());
        } catch (NumberFormatException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficevZXN̋K莞Ԃ̉͂Ɏs܂.: " + ex.toString());
        }

        // mɒ~܂B

        // OpenOffice.org̃vZXmɒ~j܂BWindowsłOpenOffice.org 2.0ȍ~ł
        // ŏ߂ăvZXIs܂B
        ensureStop();

        try {
            // OpenOffice.orgvZX̊S~mF܂B
            int retcode = procOOo.waitFor();
            if (IS_DEBUG) {
                System.out.println("OpenOfficevZX ߂l[" + retcode
                        + "]ŏI܂.");
            }
        } catch (InterruptedException ex) {
            throw new IllegalArgumentException(
                    "OpenOfficevZXI҂̍ۂɊ荞݂܂.: " + ex.toString());
        }

        // Ō̍ŌɃtB[hϐ̒lnullɃZbg܂B
        procOOo = null;
    }

    /**
     * KILLR}h\[Xoh烍[h܂B<br>
     * KILLR}h͈݂4܂ł̎wƂ܂B
     * 
     * @return
     */
    private String[] loadKillCommand() {
        final ArrayList listCommand = new ArrayList();
        if (bundle.getUnoLauncherOpenofficeKillcmd1().length() > 0) {
            listCommand.add(bundle.getUnoLauncherOpenofficeKillcmd1());
        }
        if (bundle.getUnoLauncherOpenofficeKillcmd2().length() > 0) {
            listCommand.add(bundle.getUnoLauncherOpenofficeKillcmd2());
        }
        if (bundle.getUnoLauncherOpenofficeKillcmd3().length() > 0) {
            listCommand.add(bundle.getUnoLauncherOpenofficeKillcmd3());
        }
        if (bundle.getUnoLauncherOpenofficeKillcmd4().length() > 0) {
            listCommand.add(bundle.getUnoLauncherOpenofficeKillcmd4());
        }
        if (IS_DEBUG) {
            System.out.println("killR}ḧ̐[" + listCommand.size() + "]");
            for (int index = 0; index < listCommand.size(); index++) {
                System.out.println(" R}h[" + index + "] ["
                        + (String) listCommand.get(index) + "]");
            }
        }

        final String[] result = new String[listCommand.size()];
        listCommand.toArray(result);
        return result;
    }
}