/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.util;

/**
 * blanco FrameworkɂAɊւ郆[eBeB̓܂܂܂B
 * 
 * ̃NX̓pbP[WOJƐݒ肵Ă܂B
 * 
 * @author IGA Tosiki
 */
class BlancoStringUtilTrim {
    /**
     * ^ꂽɂāAɔp󔒂 ܂B
     * 
     * p󔒂̂ݏ܂BSp󔒂͏܂B
     * 
     * @param originalString
     *            sB
     * @return p󔒂؂l߂ꂽ̕B
     */
    public static final String trimLeft(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "؂l()\bhɁAϊƂnull^܂BnullȊO̒l^ĂB");
        }
        int lastSpace = -1;
        for (int index = 0; index < originalString.length(); index++) {
            if (originalString.charAt(index) != ' ') {
                break;
            }
            lastSpace = index;
        }
        if (lastSpace < 0) {
            return originalString;
        }
        return originalString.substring(lastSpace + 1);
    }

    /**
     * ^ꂽɂāAEɔp󔒂 ܂B
     * 
     * p󔒂̂ݏ܂BSp󔒂͏܂B
     * 
     * @param originalString
     *            sB
     * @return p󔒂؂l߂ꂽ̕B
     */
    public static final String trimRight(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "؂l(E)\bhɁAϊƂnull^܂BnullȊO̒l^ĂB");
        }
        int lastSpace = -1;
        for (int index = originalString.length() - 1; index >= 0; index--) {
            if (originalString.charAt(index) != ' ') {
                break;
            }
            lastSpace = index;
        }
        if (lastSpace < 0) {
            return originalString;
        }
        return originalString.substring(0, lastSpace);
    }

    /**
     * ^ꂽɂāAEэɔp󔒂 ܂B
     * 
     * p󔒂̂ݏ܂BSp󔒂͏܂B
     * 
     * @param originalString
     *            sB
     * @return p󔒂؂l߂ꂽ̕B
     */
    public static final String trim(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "؂l(E)\bhɁAϊƂnull^܂BnullȊO̒l^ĂB");
        }
        return trimRight(trimLeft(originalString));
    }
}
