/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xsd;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeFieldStructure;
import blanco.xsd.parser.ComplexTypeStructure;
import blanco.xsd.parser.JavaTypeStructure;
import blanco.xsd.parser.SimpleTypeStructure;

/**
 * XSD͂Ƃ XSDɑ΂ЂȌ`ƂẴeXgpXMLt@C쐬܂B
 * 
 * XMLt@C ΉXSDɑ`܂B<br>
 * ȂAŐXMLt@ĆAeXgȂۂ̂ЂȌ^XML̐⏕̂ړIłB
 * SXMLt@C𐶐邱ƂۏႷ̂ł͂܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdXsd2TemplateXml {
    /**
     * fobO[hœ삷邩ǂB
     */
    private static final boolean IS_DEBUG = false;

    /**
     * ς̂̂L邽߂̃}bvB
     */
    private HashMap processedType = new HashMap();

    /**
     * XSD͂ƂăeXgpXMLt@C쐬܂B
     * 
     * @param rootNodeName
     *            [gm[hB
     * @param targetName
     *            ^[QbgƂȂGgB
     * @param fileSource
     *            \[Xt@CB
     * @param fileTarget
     *            ^[Qbgt@CB
     * @throws Exception
     *             eOꍇB
     */
    public void process(final String rootNodeName, final String targetName,
            final File fileSource, final File fileTarget) throws Exception {
        // xsdp[X܂B
        final BlancoXsdParser parser = new BlancoXsdParser();
        final ComplexTypeStructure type = parser
                .process(fileSource, targetName);

        final OutputStream outStream = new BufferedOutputStream(
                new FileOutputStream(fileTarget));
        try {
            final TransformerFactory tf = TransformerFactory.newInstance();
            final SAXTransformerFactory saxTf = (SAXTransformerFactory) tf;
            final TransformerHandler saxHandler = saxTf.newTransformerHandler();
            saxHandler.setResult(new StreamResult(outStream));
            saxHandler.startDocument();

            final AttributesImpl attrImpl = new AttributesImpl();
            // Yd̖OԂZbg܂BYXMLt@CXSDƂĂ̑Ó̂߂ɕKvłB
            attrImpl.addAttribute("", "xmlns", "xmlns", "CDATA", type
                    .getTargetNamespace());

            saxHandler.startElement("", rootNodeName, rootNodeName, attrImpl);
            expandComplexType(type, saxHandler);
            saxHandler.endElement("", rootNodeName, rootNodeName);
            saxHandler.endDocument();
            outStream.flush();
        } finally {
            outStream.close();
        }
    }

    /**
     * RvbNX^`WJ܂B
     * 
     * @param type
     *            RvbNX^̃o[IuWFNgB
     * @param saxHandler
     *            o͐ƂȂSAXnhIuWFNgB
     * @throws IOException
     *             o͗OꍇB
     * @throws SAXException
     *             SAXOꍇB
     */
    private void expandComplexType(final ComplexTypeStructure type,
            TransformerHandler saxHandler) throws IOException, SAXException {
        if (IS_DEBUG) {
            System.out.println("RvbNX^[" + type.getName() + "] TCY["
                    + type.getListField().size() + "]");
        }

        if (processedType.get(type.getName()) != null) {
            // łɏς݂łB
            return;
        }
        processedType.put(type.getName(), type);

        for (int index = 0; index < type.getListField().size(); index++) {
            final ComplexTypeFieldStructure objField = (ComplexTypeFieldStructure) type
                    .getListField().get(index);
            if (objField.getTypeStructure() instanceof JavaTypeStructure) {
                JavaTypeStructure typeField = (JavaTypeStructure) objField
                        .getTypeStructure();
                expandJavaType(typeField, objField.getFieldName(), saxHandler);
            } else if (objField.getTypeStructure() instanceof SimpleTypeStructure) {
                SimpleTypeStructure typeField = (SimpleTypeStructure) objField
                        .getTypeStructure();
                expandSimpleType(typeField, objField.getFieldName(), saxHandler);
            } else if (objField.getTypeStructure() instanceof ComplexTypeStructure) {
                ComplexTypeStructure typeField = (ComplexTypeStructure) objField
                        .getTypeStructure();
                int occur = 1;
                if (BlancoXsdUtil.isMaxOccursArray(objField.getMaxOccurs())) {
                    occur = 3;
                }
                for (int indexOccur = 0; indexOccur < occur; indexOccur++) {
                    saxHandler.startElement("", objField.getFieldName(),
                            objField.getFieldName(), new AttributesImpl());
                    expandComplexType(typeField, saxHandler);
                    saxHandler.endElement("", objField.getFieldName(), objField
                            .getFieldName());
                }
            } else {
                throw new IllegalArgumentException("\ȂO܂B^["
                        + objField.getClass().getName() + "]͓͂܂B");
            }
        }
    }

    /**
     * Vv^`WJ܂B
     * 
     * @param type
     *            Vv^`o[IuWFNgB
     * @param fieldName
     *            tB[hB
     * @param saxHandler
     *            o͐SAXnhB
     * @throws IOException
     *             o͗OꍇB
     * @throws SAXException
     *             SAXOꍇB
     */
    private void expandSimpleType(final SimpleTypeStructure type,
            final String fieldName, TransformerHandler saxHandler)
            throws IOException, SAXException {
        if (IS_DEBUG) {
            System.out.println("Vv^[" + type.getName() + "]");
        }
        if (type.getBaseRestriction() != null) {
            expandSimpleType(type.getBaseRestriction(), fieldName, saxHandler);
        } else {
            final JavaTypeStructure typeNew = new JavaTypeStructure();
            typeNew.setName(type.getName());
            typeNew.setTypeOfJava(type.getTypeOfNamespace().substring(
                    "xsd:".length()));
            typeNew.setTypeOfJava(BlancoXsdTypeMapping.xsdType2JavaType(type
                    .getTypeOfNamespace(), "1"));
            if (IS_DEBUG) {
                System.out.println("name:" + typeNew.getName() + ", type:"
                        + typeNew.getTypeOfJava());
            }
            expandJavaType(typeNew, fieldName, saxHandler);
        }
    }

    /**
     * Java^WJ܂B
     * 
     * @param type
     *            Java^̃o[IuWFNgB
     * @param fieldName
     *            tB[hB
     * @param saxHandler
     *            o͐SAXnhB
     * @throws IOException
     *             o͗OꍇB
     * @throws SAXException
     *             SAXOꍇB
     */
    private void expandJavaType(final JavaTypeStructure type,
            final String fieldName, TransformerHandler saxHandler)
            throws IOException, SAXException {
        if (IS_DEBUG) {
            System.out.println("Java^:" + type.getName());
        }
        saxHandler.startElement("", fieldName, fieldName, new AttributesImpl());
        if (type.getTypeOfJavaWithoutArray().equals("java.lang.String")) {
            final char[] value = "".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJavaWithoutArray().equals("int")
                || type.getTypeOfJavaWithoutArray().equals("java.lang.Integer")) {
            final char[] value = "123".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJavaWithoutArray().equals("long")
                || type.getTypeOfJavaWithoutArray().equals("java.lang.Long")) {
            final char[] value = "1234567890".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJavaWithoutArray().equals("boolean")
                || type.getTypeOfJavaWithoutArray().equals("java.lang.Boolean")) {
            final char[] value = "true".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJavaWithoutArray().equals("java.util.Date")) {
            final char[] value = "2005/12/31".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else if (type.getTypeOfJavaWithoutArray().equals(
                "java.math.BigDecimal")) {
            final char[] value = "1234.567".toCharArray();
            saxHandler.characters(value, 0, value.length);
        } else {
            throw new IllegalArgumentException("sȌ^["
                    + type.getTypeOfJavaWithoutArray() + "]܂B");
        }
        saxHandler.endElement("", fieldName, fieldName);
        saxHandler.characters("\n".toCharArray(), 0, "\n".toCharArray().length);
    }
}