/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.test.valueobject.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;
import blanco.test.valueobject.resourcebundle.BlancoValueObjectTestResourceBundle;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * ValueObject\XMLt@C JUnitpJava\[XR[h܂B
 * 
 * String^̂߂̃eXg\bh𐶐܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JUnitNotSupportedMethod extends
        MethodExpander {
    private final BlancoValueObjectTestResourceBundle bundle = new BlancoValueObjectTestResourceBundle();

    /**
     * tB[h⃁\bh̖Oό`sǂB
     */
    private boolean fNameAdjust = true;

    private BlancoValueObjectClassStructure classInfo = null;

    private BlancoValueObjectFieldStructure field = null;

    private Constructor findConstructor = null;

    public BlancoValueObjectXml2JUnitNotSupportedMethod(final String arg,
            final BlancoValueObjectClassStructure classStructure,
            final BlancoValueObjectFieldStructure fieldInfo,
            final boolean isNameAdjust) {
        super(arg);
        classInfo = classStructure;
        field = fieldInfo;
        fNameAdjust = isNameAdjust;
    }

    // \bh̃VOj`w
    public void setupSignature() {
        addException(new Type("java.lang.Exception"));
        getJavaDoc().addLine("tB[h[" + field.getName() + "]̒P̎\bh<br>");

        try {
            final Class findClass = Class.forName(field.getType());
            findConstructor = findClass.getConstructor(new Class[0]);

            if (Modifier.isPublic(findConstructor.getModifiers())) {
                getJavaDoc()
                        .addLine(
                                "NX["
                                        + classInfo.getName()
                                        + "]̃tB[h["
                                        + field.getName()
                                        + "]͌^["
                                        + field.getType()
                                        + "]łB̌^̃ftHgRXgN^ĂяoȂP̎s܂BftHgRXgN^̌Ăяop𔭐ꍇɂ́ÃtB[hɑ΂鎩P͎̎sȂłB<br>");
            } else {
                getJavaDoc().addLine(
                        "TODO NX["
                                + classInfo.getName()
                                + "]̃tB[h["
                                + field.getName()
                                + "]͌^["
                                + field.getType()
                                + "]łǍ^̓ftHgRXgN^publicł͂Ȃ("
                                + Modifier.toString(findConstructor
                                        .getModifiers())
                                + ")ߒP͎̎̎ł܂B");
                // nullŃNA
                findConstructor = null;
            }
        } catch (ClassNotFoundException e) {
            // NX̃[hɎsꍇB̃P[X肦܂B
            getJavaDoc()
                    .addLine(
                            "TODO NX["
                                    + classInfo.getName()
                                    + "]̃tB[h["
                                    + field.getName()
                                    + "]Ɍ^["
                                    + field.getType()
                                    + "]w肳Ă܂Ǎ^̃CX^XɎs܂BLȌ^ł邩ǂmFĂBP͎̎̎ł܂B");
        } catch (NoSuchMethodException e) {
            // ftHgRXgN^擾łȂꍇB̃p^[͕ʂɂ肦܂B̂܂ܗ܂B
            getJavaDoc()
                    .addLine(
                            "TODO NX["
                                    + classInfo.getName()
                                    + "]̃tB[h["
                                    + field.getName()
                                    + "]͌^["
                                    + field.getType()
                                    + "]łǍ^̓ftHgRXgN^܂B̂ߒP͎̎̎ł܂B");
        }
    }

    // \bh̎
    public void implement() {
        if (findConstructor == null) {
            getData().addLine(
                    "// TODO NX[" + classInfo.getName() + "]̃tB[h["
                            + field.getName() + "]̒P̎ɂĂ͎̑Ώ۔͈͊OłB");
        } else {
            final String fieldNameAdjustered = (fNameAdjust == false ? field
                    .getName() : BlancoNameAdjuster
                    .toClassName(field.getName()));

            addUsingType(new Type(field.getType()));

            getData().addLine(bundle.getMethodOtherobjectB01L01());
            getData().addLine(
                    bundle.getMethodOtherobjectB01L02(classInfo.getName()));
            getData().addLine(bundle.getMethodOtherobjectB01L03());

            getData().addLine(bundle.getMethodOtherobjectB02L01());
            getData().addLine(
                    bundle.getMethodOtherobjectB02L02(classInfo.getName(),
                            field.getName(), fieldNameAdjustered));
            getData().addLine(bundle.getMethodOtherobjectB02L03());

            getData().addLine(bundle.getMethodOtherobjectB03L01());
            getData().addLine(
                    bundle.getMethodOtherobjectB03L02(BlancoNameUtil
                            .trimJavaPackage(field.getType())));
            getData().addLine(
                    bundle.getMethodOtherobjectB03L03(fieldNameAdjustered));
            getData().addLine(
                    bundle.getMethodOtherobjectB03L04(classInfo.getName(),
                            field.getName(), BlancoNameUtil
                                    .trimJavaPackage(field.getType()),
                            fieldNameAdjustered));
            getData().addLine(bundle.getMethodOtherobjectB03L05());

            getData().addLine(bundle.getMethodOtherobjectB04L01());
            getData().addLine(
                    bundle.getMethodOtherobjectB04L02(fieldNameAdjustered));
            getData().addLine(
                    bundle.getMethodOtherobjectB04L03(classInfo.getName(),
                            field.getName(), fieldNameAdjustered));
            getData().addLine(bundle.getMethodOtherobjectB04L04());
        }
    }
}
