/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.soap.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.soap.BlancoSoapWsdl2Asmx;

/**
 * BlancoSOAPAnt^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoSoapDotNetWsdl2AsmxTask extends
        AbstractBlancoSoapDotNetWsdl2AsmxTask {

    /**
     * AntTask̏s܂B
     * 
     * ̃\bh ېeNXłAbstractBlancoCsvTaskNXĂяo܂B
     * 
     * @throws IllegalArgumentException
     *             e͒lȌꍇɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            final File fileTargetdir = new File(getTargetdir());
            if (fileTargetdir.exists() == false) {
                if (fileTargetdir.mkdirs() == false) {
                    throw new IllegalArgumentException("o͐fBNg["
                            + getMetadir() + "]̍쐬Ɏs܂B");
                }
            }

            final File[] fileMeta = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta.length; index++) {
                if (fileMeta[index].getName().endsWith(".wsdl") == false) {
                    continue;
                }
                try {
                    new BlancoSoapWsdl2Asmx().process(fileMeta[index],
                            new File(getTargetdir()));
                } catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("t@C["
                            + fileMeta[index] + "]̏̂ŗO܂B"
                            + ex.toString());
                }
            }
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}
